/*
 * Decompiled with CFR 0.152.
 */
package scavenge.loot.effects;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import scavenge.api.ScavengeAPI;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.loot.ILootProperty;
import scavenge.api.loot.impl.BaseLootFactory;
import scavenge.api.loot.impl.BasePassiveLootProperty;

public class PropAddTag
extends BasePassiveLootProperty {
    String key;
    NBTBase base;

    public PropAddTag(JsonObject obj) {
        super("add_tag");
        this.key = obj.get("key").getAsString();
        this.base = this.createValue(obj);
        if (this.base == null) {
            throw new RuntimeException("Value [" + obj + "] causes a null thats not allowed!");
        }
    }

    protected NBTBase createValue(JsonObject obj) {
        String type = obj.get("value_type").getAsString();
        JsonElement el = obj.get("value");
        if (type.equalsIgnoreCase("long")) {
            return new NBTTagLong(el.getAsLong());
        }
        if (type.equalsIgnoreCase("byte")) {
            return new NBTTagByte(el.getAsByte());
        }
        if (type.equalsIgnoreCase("short")) {
            return new NBTTagShort(el.getAsShort());
        }
        if (type.equalsIgnoreCase("int")) {
            return new NBTTagInt(el.getAsInt());
        }
        if (type.equalsIgnoreCase("float")) {
            return new NBTTagFloat(el.getAsFloat());
        }
        if (type.equalsIgnoreCase("double")) {
            return new NBTTagDouble(el.getAsDouble());
        }
        if (type.equalsIgnoreCase("boolean")) {
            return new NBTTagByte((byte)(el.getAsBoolean() ? 1 : 0));
        }
        if (type.equalsIgnoreCase("string")) {
            return new NBTTagString(el.getAsString());
        }
        if (type.equalsIgnoreCase("compound")) {
            return ScavengeAPI.INSTANCE.getCompound(el.getAsString());
        }
        return null;
    }

    @Override
    public ItemStack applyPassiveEffect(ItemStack stack) {
        stack.func_77983_a(this.key, this.base);
        return stack;
    }

    @Override
    public ItemStack applyInfoEffect(ItemStack stack) {
        stack.func_77983_a(this.key, this.base);
        return stack;
    }

    public static class AddTagFactory
    extends BaseLootFactory {
        public AddTagFactory() {
            super("add_tag", false);
        }

        @Override
        public ILootProperty createObject(JsonObject obj) {
            return new PropAddTag(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = new MapElement("");
            map.setDescription("Allows to add a NBTTag to the item");
            map.addElement(new TextElement("key", "").setDescription("the key of the NBTTag"));
            map.addElement(new TextElement("value_type", "").setDescription("The Type of Value you want to create"));
            map.addElement(new TextElement("value", "").setDescription("The Value that you want to store").setType("Mixed"));
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("key", "testKey");
            obj.addProperty("value_type", "long");
            obj.addProperty("value", (Number)1234);
        }
    }
}

