/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.math.operation;

import com.google.gson.JsonObject;
import scavenge.api.autodoc.LongElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.math.IMathOperation;
import scavenge.api.math.impl.BaseMathOperation;
import scavenge.api.math.impl.BaseOperationFactory;
import scavenge.api.utils.CompatState;

public class InRangeOperation
extends BaseMathOperation {
    long min;
    long max;

    public InRangeOperation(JsonObject obj) {
        this(obj.get("minValue").getAsLong(), obj.get("maxValue").getAsLong());
        if (obj.has("modifiers")) {
            this.addMathModifiers(obj.get("modifiers"));
        }
    }

    public InRangeOperation(long minValue, long maxValue) {
        super("inRange");
        this.min = minValue;
        this.max = maxValue;
    }

    @Override
    public boolean matches(long value) {
        return (value = this.getValue(value)) >= this.min && value <= this.max;
    }

    public static class InRangeFactory
    extends BaseOperationFactory {
        public InRangeFactory() {
            super("inRange");
            this.setCompatState(CompatState.PARTCOMPATIBLE);
        }

        @Override
        public IMathOperation createObject(JsonObject obj) {
            return new InRangeOperation(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new LongElement("minValue", 0L).setDescription("The Minimum Value the Operation should compare with"));
            map.addElement(new LongElement("maxValue", 0L).setDescription("The Maximum Value the Operation should compare with"));
            map.setDescription("Checks if the Input Value is in range of the Input Values");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("minValue", (Number)10);
            obj.addProperty("maxValue", (Number)100);
        }
    }
}

