/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.math.modifiers;

import com.google.gson.JsonObject;
import scavenge.api.autodoc.LongElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.math.IMathModifier;
import scavenge.api.math.impl.BaseMathModifier;
import scavenge.api.math.impl.BaseModifierFactory;

public class MultiplierModifier
extends BaseMathModifier {
    long value;

    public MultiplierModifier(JsonObject obj) {
        this(obj.get("value").getAsLong());
    }

    public MultiplierModifier(long value) {
        super("multiply");
        this.value = value;
    }

    @Override
    public long modify(long input) {
        return input * this.value;
    }

    public static class MultiplyFactory
    extends BaseModifierFactory {
        public MultiplyFactory() {
            super("multiply");
        }

        @Override
        public IMathModifier createObject(JsonObject obj) {
            return new MultiplierModifier(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = new MapElement("");
            map.addElement(new LongElement("value", 0L).setDescription("The Value that should be Multiplied with"));
            map.setDescription("Multiplies the Input Value with a Selected Value");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("value", (Number)100);
        }
    }
}

