/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.math;

import scavenge.api.ScavengeAPI;
import scavenge.api.math.IMathRegistry;
import scavenge.core.math.modifiers.AddModifier;
import scavenge.core.math.modifiers.DevideModifier;
import scavenge.core.math.modifiers.ModulusModifier;
import scavenge.core.math.modifiers.MultiplierModifier;
import scavenge.core.math.modifiers.PowModifier;
import scavenge.core.math.modifiers.RemoveModifier;
import scavenge.core.math.operation.BiggerEqualsOperation;
import scavenge.core.math.operation.BiggerOperation;
import scavenge.core.math.operation.EqualsNotOperation;
import scavenge.core.math.operation.EqualsOperation;
import scavenge.core.math.operation.InRangeOperation;
import scavenge.core.math.operation.NotInRangeOperation;
import scavenge.core.math.operation.SmallerEqualsOperation;
import scavenge.core.math.operation.SmallerOperation;

public class ScavengeMath {
    public static ScavengeMath INSTANCE = new ScavengeMath();

    public void register(ScavengeAPI api) {
        IMathRegistry registry = api.getMathRegistry();
        registry.registerOperationFactory(new EqualsOperation.EqualsFactory());
        registry.registerOperationFactory(new EqualsNotOperation.EqualsNotFactory());
        registry.registerOperationFactory(new BiggerOperation.BiggerFactory());
        registry.registerOperationFactory(new BiggerEqualsOperation.BiggerEqualsFactory());
        registry.registerOperationFactory(new SmallerOperation.SmallerFactory());
        registry.registerOperationFactory(new SmallerEqualsOperation.SmallerEqualsFactory());
        registry.registerOperationFactory(new InRangeOperation.InRangeFactory());
        registry.registerOperationFactory(new NotInRangeOperation.NotInRangeFactory());
        registry.registerModifierFactory(new AddModifier.AddFactory());
        registry.registerModifierFactory(new RemoveModifier.RemoveFactory());
        registry.registerModifierFactory(new MultiplierModifier.MultiplyFactory());
        registry.registerModifierFactory(new DevideModifier.DevideFactory());
        registry.registerModifierFactory(new PowModifier.PowFactory());
        registry.registerModifierFactory(new ModulusModifier.ModulusFactory());
    }
}

