/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.jei;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import scavenge.api.block.IResourceProperty;
import scavenge.api.utils.BlockEntry;
import scavenge.core.builder.block.IBlockResource;
import scavenge.core.jei.GuiJEIList;
import scavenge.core.jei.JEIHolder;
import scavenge.core.loot.ILoot;

@SideOnly(value=Side.CLIENT)
public class ScavengeWrapper
extends BlankRecipeWrapper {
    IBlockResource res;
    List<List<ItemStack>> input = new ArrayList<List<ItemStack>>();
    List<List<ItemStack>> output = new ArrayList<List<ItemStack>>();
    Map<Integer, ILoot> loots = new HashMap<Integer, ILoot>();
    JEIHolder.InfoComponent conditions = null;
    JEIHolder.InfoComponent effects = null;
    GuiButton conditionButton;
    GuiButton effectButton;
    IDrawable slot;
    IDrawable arrow;

    public ScavengeWrapper(IBlockResource arg0) {
        this.res = arg0;
        this.init();
    }

    public void getIngredients(IIngredients arg0) {
        arg0.setInputLists(ItemStack.class, this.input);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (List<ItemStack> entry : this.output) {
            list.addAll(entry);
        }
        arg0.setOutputs(ItemStack.class, list);
    }

    public void init() {
        this.input.add(new ArrayList());
        List<BlockEntry> entryList = this.res.getBlockEntries();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (BlockEntry entry : entryList) {
            if (!entry.hasItemBlock()) continue;
            list.add(entry.toStack());
        }
        this.input.add(list);
        this.output.add(new ArrayList());
        JEIHolder holder = new JEIHolder();
        for (IResourceProperty iResourceProperty : this.res.getConditions()) {
            iResourceProperty.addJEIData(holder);
        }
        this.conditions = holder.base;
        this.conditions.name = "Conditions";
        this.input.get(0).addAll(holder.requiredItems);
        this.output.get(0).addAll(holder.transformBlocks);
        holder = new JEIHolder();
        for (IResourceProperty iResourceProperty : this.res.getEffects()) {
            iResourceProperty.addJEIData(holder);
        }
        this.effects = holder.base;
        this.effects.name = "Effects";
        for (ILoot iLoot : this.res.getLoot()) {
            if (!iLoot.shouldShow()) continue;
            int index = this.output.size();
            this.loots.put(index, iLoot);
            this.output.add(iLoot.generateAllDrops());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.conditionButton != null) {
            this.effectButton.field_146124_l = this.conditions.getSubComponents().size() > 0;
            this.conditionButton.func_191745_a(minecraft, mouseX, mouseY, 0.0f);
        }
        if (this.effectButton != null) {
            this.effectButton.field_146124_l = this.effects.getSubComponents().size() > 0;
            this.effectButton.func_191745_a(minecraft, mouseX, mouseY, 0.0f);
        }
        if (this.arrow == null || this.slot == null) {
            return;
        }
        if (this.input.get(0).size() > 0) {
            this.arrow.draw(minecraft, 47, 39);
            this.slot.draw(minecraft, 25, 39);
        }
        if (this.output.get(0).size() > 0) {
            this.arrow.draw(minecraft, 100, 39);
            this.slot.draw(minecraft, 130, 39);
        }
    }

    public void setDrawer(IDrawable arrow, IDrawable slot) {
        this.arrow = arrow;
        this.slot = slot;
        this.conditionButton = new GuiButton(0, 3, 60, 60, 10, "Conditions");
        this.effectButton = new GuiButton(0, 104, 60, 60, 10, "Effects");
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return new ArrayList<String>();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        if (this.conditionButton.func_146116_c(minecraft, mouseX, mouseY)) {
            minecraft.func_147108_a((GuiScreen)new GuiJEIList(minecraft.field_71462_r, this.conditions));
            return true;
        }
        if (this.effectButton.func_146116_c(minecraft, mouseX, mouseY)) {
            minecraft.func_147108_a((GuiScreen)new GuiJEIList(minecraft.field_71462_r, this.effects));
            return true;
        }
        return super.handleClick(minecraft, mouseX, mouseY, mouseButton);
    }
}

