/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IStackHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import scavenge.core.jei.ScavengeWrapper;
import scavenge.core.loot.ILoot;

public class ScavengeCategory
implements IRecipeCategory<ScavengeWrapper> {
    IDrawable background;
    IDrawable slot;
    IDrawable arrow;
    IStackHelper stackHelper;

    public ScavengeCategory(IGuiHelper helper, IStackHelper stack) {
        ResourceLocation texture = new ResourceLocation("scavenge", "textures/jeigui.png");
        this.background = helper.createDrawable(texture, 0, 0, 168, 158, 25, 0, 0, 0);
        this.slot = helper.createDrawable(texture, 170, 18, 18, 18);
        this.arrow = helper.createDrawable(texture, 170, 0, 22, 16);
        this.stackHelper = stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawExtras(Minecraft arg0) {
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public String getTitle() {
        return "Scavenge";
    }

    public List<String> getTooltipStrings(int arg0, int arg1) {
        return new ArrayList<String>();
    }

    public String getUid() {
        return "scavenge.click";
    }

    public void setRecipe(IRecipeLayout layout, final ScavengeWrapper wrapper, IIngredients arg2) {
        wrapper.setDrawer(this.arrow, this.slot);
        IGuiItemStackGroup stacks = layout.getItemStacks();
        stacks.init(0, false, 25, 39);
        stacks.init(1, false, 75, 39);
        stacks.init(2, true, 130, 39);
        int index = 3;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int xPos = x * 18 + 3;
                int yPos = y * 18 + 74;
                stacks.init(index, true, xPos, yPos);
                ++index;
            }
        }
        stacks.set(0, wrapper.input.get(0));
        stacks.set(1, wrapper.input.get(1));
        index = 2;
        for (int i = 0; i < wrapper.output.size(); ++i) {
            stacks.set(index + i, wrapper.output.get(i));
        }
        stacks.addTooltipCallback((ITooltipCallback)new ITooltipCallback<ItemStack>(){

            public void onTooltip(int arg0, boolean arg1, ItemStack arg2, List<String> arg3) {
                ILoot loot = wrapper.loots.get(arg0 - 2);
                if (loot == null) {
                    return;
                }
                if (!loot.usesWeight()) {
                    arg3.add(loot.getChance() + "% Chance");
                }
            }
        });
    }

    public String getModName() {
        return "scavenge";
    }
}

