/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.handlers;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import scavenge.api.world.IGlobalHandler;
import scavenge.api.world.IWorldHandler;
import scavenge.api.world.IWorldRegistry;
import scavenge.core.handlers.GlobalWorldHandler;
import scavenge.core.handlers.PerWorldHandler;

public class WorldRegistry
implements IWorldRegistry {
    public Map<World, WorldStructures> map = new HashMap<World, WorldStructures>();

    public WorldRegistry() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public IWorldHandler getStorageForWorld(World world) {
        MapStorage storage = world.getPerWorldStorage();
        PerWorldHandler handler = (PerWorldHandler)storage.func_75742_a(PerWorldHandler.class, "ScavengeLocalData");
        if (handler == null) {
            handler = new PerWorldHandler("ScavengeLocalData");
            storage.func_75745_a("ScavengeLocalData", (WorldSavedData)handler);
        }
        return handler;
    }

    @Override
    public IGlobalHandler getGlobalHandler(World world) {
        GlobalWorldHandler handler = (GlobalWorldHandler)world.func_72943_a(GlobalWorldHandler.class, "ScavengeGlobalData");
        if (handler == null) {
            handler = new GlobalWorldHandler("ScavengeGlobalData");
            world.func_72823_a("ScavengeGlobalData", (WorldSavedData)handler);
        }
        return handler;
    }

    @Override
    public Set<String> getStructures(World world) {
        WorldStructures entry = this.map.get(world);
        return entry == null ? new HashSet() : entry.getStructures();
    }

    @Override
    public boolean isInsideStructure(World world, String structure, BlockPos position) {
        WorldStructures entry = this.map.get(world);
        return entry == null ? false : entry.hasStructure(structure, position);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (world instanceof WorldServer) {
            WorldStructures structures = new WorldStructures();
            structures.init((WorldServer)world);
            this.map.put(world, structures);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        this.map.remove(event.getWorld());
    }

    public static class WorldStructures {
        Map<String, MapGenStructure> structures = new HashMap<String, MapGenStructure>();

        public void init(WorldServer world) {
            for (MapGenStructure structure : this.getStructures(world.func_72863_F().field_186029_c)) {
                this.structures.put(structure.func_143025_a().toLowerCase(Locale.ENGLISH), structure);
            }
        }

        public boolean hasStructure(String id, BlockPos pos) {
            MapGenStructure entry = this.structures.get(id.toLowerCase(Locale.ENGLISH));
            return entry == null ? false : entry.func_175795_b(pos);
        }

        public Set<String> getStructures() {
            return this.structures.keySet();
        }

        private List<MapGenStructure> getStructures(IChunkGenerator generator) {
            ArrayList<MapGenStructure> list = new ArrayList<MapGenStructure>();
            Class<MapGenStructure> structure = MapGenStructure.class;
            try {
                Class<?> clz = generator.getClass();
                Field[] fields = clz.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    if (!structure.isAssignableFrom(field.getType())) continue;
                    field.setAccessible(true);
                    list.add((MapGenStructure)field.get(generator));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return list;
        }
    }
}

