/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import scavenge.api.ScavengeAPI;
import scavenge.api.utils.BlockEntry;
import scavenge.api.world.IWorldHandler;
import scavenge.core.builder.block.IBlockResource;

public class ScavengeHandler {
    public static ScavengeHandler INSTANCE = new ScavengeHandler();
    List<IBlockResource> allResources = new ArrayList<IBlockResource>();
    Map<String, IBlockResource> mappedResources = new LinkedHashMap<String, IBlockResource>();
    Map<BlockEntry, List<IBlockResource>>[] metaResources = new HashMap[4];
    Map<Block, List<IBlockResource>>[] blankResources = new HashMap[4];
    public static final int RIGHT_CLICK = 0;
    public static final int LEFT_CLICK = 1;
    public static final int BLOCK_BREAK = 2;
    public static final int BLOCK_PLACE = 3;

    public void init() {
        for (int i = 0; i < this.metaResources.length; ++i) {
            this.metaResources[i] = new LinkedHashMap<BlockEntry, List<IBlockResource>>();
            this.blankResources[i] = new LinkedHashMap<Block, List<IBlockResource>>();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void clear() {
        this.allResources.clear();
        this.mappedResources.clear();
        for (int i = 0; i < this.metaResources.length; ++i) {
            this.metaResources[i].clear();
            this.blankResources[i].clear();
        }
    }

    @SubscribeEvent
    public void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        World world = event.getWorld();
        if (!world.field_72995_K) {
            BlockPos pos = event.getPos();
            IBlockState state = world.func_180495_p(pos);
            for (IBlockResource res : this.getResources(state, 0)) {
                if (!res.matches(state, event.getEntityPlayer(), pos, false, event.getFace(), false)) continue;
                if (res.isBlockingRightClick()) {
                    event.setCanceled(true);
                }
                res.applyEffect(state, world, pos, false, event.getFace(), event.getEntityPlayer());
                return;
            }
        } else {
            BlockPos pos = event.getPos();
            IBlockState state = world.func_180495_p(pos);
            for (IBlockResource res : this.getResources(state, 0)) {
                if (!res.matches(state, event.getEntityPlayer(), pos, false, event.getFace(), true) || !res.isBlockingRightClick()) continue;
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onBlockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            BlockPos pos = event.getPos();
            IBlockState state = world.func_180495_p(pos);
            for (IBlockResource res : this.getResources(state, 1)) {
                if (!res.matches(state, event.getEntityPlayer(), pos, true, event.getFace(), false)) continue;
                if (res.isBlockingLeftClick()) {
                    event.setCanceled(true);
                }
                res.applyEffect(state, world, pos, false, event.getFace(), event.getEntityPlayer());
                return;
            }
        } else {
            BlockPos pos = event.getPos();
            IBlockState state = world.func_180495_p(pos);
            for (IBlockResource res : this.getResources(state, 1)) {
                if (!res.matches(state, event.getEntityPlayer(), pos, true, event.getFace(), true) || !res.isBlockingLeftClick()) continue;
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void canBreakEvent(BlockEvent.BreakEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        IWorldHandler handler = ScavengeAPI.INSTANCE.getWorldRegistry().getStorageForWorld(event.getWorld());
        if (handler.isUnbreakable(event.getPos(), event.getState())) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onBlockBroke(BlockEvent.HarvestDropsEvent event) {
        if (!event.getWorld().field_72995_K) {
            ScavengeAPI.INSTANCE.getWorldRegistry().getStorageForWorld(event.getWorld()).removeBlockUnbreaking(event.getPos());
        }
    }

    public void addResource(IBlockResource resource) {
        if (resource == null) {
            return;
        }
        this.allResources.add(resource);
        this.mappedResources.put(resource.getID(), resource);
        if (resource.isLeftClick()) {
            this.addEntry(resource, 1);
        }
        if (resource.isRightClick()) {
            this.addEntry(resource, 0);
        }
        if (resource.isBreaking()) {
            this.addEntry(resource, 2);
        }
        if (resource.isPlacing()) {
            this.addEntry(resource, 3);
        }
    }

    private void addEntry(IBlockResource block, int index) {
        for (BlockEntry entry : block.getBlockEntries()) {
            List<IBlockResource> res;
            if (entry.isBlank()) {
                res = this.blankResources[index].get(entry.getBlock());
                if (res == null) {
                    res = new ArrayList<IBlockResource>();
                    this.blankResources[index].put(entry.getBlock(), res);
                }
                res.add(block);
                continue;
            }
            res = this.metaResources[index].get(entry);
            if (res == null) {
                res = new ArrayList<IBlockResource>();
                this.metaResources[index].put(entry, res);
            }
            res.add(block);
        }
    }

    public List<IBlockResource> getResources(IBlockState state, int type) {
        List resources = this.metaResources[type].getOrDefault(new BlockEntry(state), new ArrayList());
        resources.addAll(this.blankResources[type].getOrDefault(state.func_177230_c(), new ArrayList()));
        return resources;
    }

    public List<IBlockResource> getAllResources() {
        return new ArrayList<IBlockResource>(this.allResources);
    }

    public IBlockResource getResource(String id) {
        return this.mappedResources.get(id);
    }
}

