/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.handlers;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.storage.WorldSavedData;
import scavenge.api.utils.IntCounter;
import scavenge.api.world.IDelivered;
import scavenge.api.world.IWorldHandler;
import scavenge.core.builder.block.IBlockResource;
import scavenge.core.handlers.ScavengeHandler;

public class PerWorldHandler
extends WorldSavedData
implements IWorldHandler {
    Map<String, IntCounter> counters = new LinkedHashMap<String, IntCounter>();
    Map<String, Map<BlockPos, IntCounter>> blockCounters = new LinkedHashMap<String, Map<BlockPos, IntCounter>>();
    Map<String, Map<ChunkPos, IntCounter>> chunkCounters = new LinkedHashMap<String, Map<ChunkPos, IntCounter>>();
    Map<String, NBTTagCompound> customData = new LinkedHashMap<String, NBTTagCompound>();
    Map<String, Map<BlockPos, NBTTagCompound>> blockCustomData = new LinkedHashMap<String, Map<BlockPos, NBTTagCompound>>();
    Map<String, Map<ChunkPos, NBTTagCompound>> chunkCustomData = new LinkedHashMap<String, Map<ChunkPos, NBTTagCompound>>();
    Map<BlockPos, Set<String>> unbreakables = new LinkedHashMap<BlockPos, Set<String>>();

    public PerWorldHandler(String name) {
        super(name);
    }

    @Override
    public IDelivered<IntCounter> getCounter(final String id) {
        return new IDelivered<IntCounter>(){

            @Override
            public IntCounter get() {
                IntCounter counter = PerWorldHandler.this.counters.get(id);
                if (counter == null) {
                    counter = new IntCounter(0);
                    PerWorldHandler.this.counters.put(id, counter);
                    this.onChanged();
                }
                return counter;
            }

            @Override
            public boolean exists() {
                return PerWorldHandler.this.counters.containsKey(id);
            }

            @Override
            public void onChanged() {
                PerWorldHandler.this.func_76185_a();
            }

            @Override
            public void remove() {
                PerWorldHandler.this.counters.remove(id);
                this.onChanged();
            }
        };
    }

    @Override
    public IDelivered<IntCounter> getCounterPerBlock(final String id, final BlockPos pos) {
        return new IDelivered<IntCounter>(){

            @Override
            public IntCounter get() {
                IntCounter counter;
                Map<BlockPos, IntCounter> map = PerWorldHandler.this.blockCounters.get(id);
                if (map == null) {
                    map = new LinkedHashMap<BlockPos, IntCounter>();
                    PerWorldHandler.this.blockCounters.put(id, map);
                }
                if ((counter = map.get(pos)) == null) {
                    counter = new IntCounter(0);
                    map.put(pos, counter);
                    this.onChanged();
                }
                return counter;
            }

            @Override
            public boolean exists() {
                if (!PerWorldHandler.this.blockCounters.containsKey(id)) {
                    return false;
                }
                return PerWorldHandler.this.blockCounters.get(id).containsKey(pos);
            }

            @Override
            public void onChanged() {
                PerWorldHandler.this.func_76185_a();
            }

            @Override
            public void remove() {
                Map<BlockPos, IntCounter> counters = PerWorldHandler.this.blockCounters.get(id);
                if (counters == null) {
                    return;
                }
                counters.remove(pos);
                this.onChanged();
                if (counters.isEmpty()) {
                    PerWorldHandler.this.blockCounters.remove(id);
                }
            }
        };
    }

    @Override
    public IDelivered<IntCounter> getCounterPerChunk(final String id, final BlockPos pos) {
        return new IDelivered<IntCounter>(){

            @Override
            public IntCounter get() {
                IntCounter counter;
                Map<ChunkPos, IntCounter> map = PerWorldHandler.this.chunkCounters.get(id);
                if (map == null) {
                    map = new LinkedHashMap<ChunkPos, IntCounter>();
                    PerWorldHandler.this.chunkCounters.put(id, map);
                }
                if ((counter = map.get(pos)) == null) {
                    counter = new IntCounter(0);
                    map.put(new ChunkPos(pos), counter);
                    this.onChanged();
                }
                return counter;
            }

            @Override
            public boolean exists() {
                if (!PerWorldHandler.this.chunkCounters.containsKey(id)) {
                    return false;
                }
                return PerWorldHandler.this.chunkCounters.get(id).containsKey(new ChunkPos(pos));
            }

            @Override
            public void onChanged() {
                PerWorldHandler.this.func_76185_a();
            }

            @Override
            public void remove() {
                Map<ChunkPos, IntCounter> counters = PerWorldHandler.this.chunkCounters.get(id);
                if (counters == null) {
                    return;
                }
                counters.remove(new ChunkPos(pos));
                this.onChanged();
                if (counters.isEmpty()) {
                    PerWorldHandler.this.chunkCounters.remove(id);
                }
            }
        };
    }

    @Override
    public IDelivered<NBTTagCompound> getCustomData(final String id) {
        return new IDelivered<NBTTagCompound>(){

            @Override
            public NBTTagCompound get() {
                NBTTagCompound nbt = PerWorldHandler.this.customData.get(id);
                if (nbt == null) {
                    nbt = new NBTTagCompound();
                    PerWorldHandler.this.customData.put(id, nbt);
                    this.onChanged();
                }
                return nbt;
            }

            @Override
            public boolean exists() {
                return PerWorldHandler.this.customData.containsKey(id);
            }

            @Override
            public void onChanged() {
                PerWorldHandler.this.func_76185_a();
            }

            @Override
            public void remove() {
                PerWorldHandler.this.customData.remove(id);
                this.onChanged();
            }
        };
    }

    @Override
    public IDelivered<NBTTagCompound> getCustomDataPerBlock(final String id, final BlockPos pos) {
        return new IDelivered<NBTTagCompound>(){

            @Override
            public NBTTagCompound get() {
                NBTTagCompound data;
                Map<BlockPos, NBTTagCompound> map = PerWorldHandler.this.blockCustomData.get(id);
                if (map == null) {
                    map = new LinkedHashMap<BlockPos, NBTTagCompound>();
                    PerWorldHandler.this.blockCustomData.put(id, map);
                }
                if ((data = map.get(pos)) == null) {
                    data = new NBTTagCompound();
                    map.put(pos, data);
                    this.onChanged();
                }
                return data;
            }

            @Override
            public boolean exists() {
                if (!PerWorldHandler.this.blockCustomData.containsKey(id)) {
                    return false;
                }
                return PerWorldHandler.this.blockCustomData.get(id).containsKey(pos);
            }

            @Override
            public void onChanged() {
                PerWorldHandler.this.func_76185_a();
            }

            @Override
            public void remove() {
                Map<BlockPos, NBTTagCompound> counters = PerWorldHandler.this.blockCustomData.get(id);
                if (counters == null) {
                    return;
                }
                counters.remove(pos);
                this.onChanged();
                if (counters.isEmpty()) {
                    PerWorldHandler.this.blockCustomData.remove(id);
                }
            }
        };
    }

    @Override
    public IDelivered<NBTTagCompound> getCustomDataPerChunk(final String id, final BlockPos pos) {
        return new IDelivered<NBTTagCompound>(){

            @Override
            public NBTTagCompound get() {
                NBTTagCompound data;
                Map<ChunkPos, NBTTagCompound> map = PerWorldHandler.this.chunkCustomData.get(id);
                if (map == null) {
                    map = new LinkedHashMap<ChunkPos, NBTTagCompound>();
                    PerWorldHandler.this.chunkCustomData.put(id, map);
                }
                if ((data = map.get(pos)) == null) {
                    data = new NBTTagCompound();
                    map.put(new ChunkPos(pos), data);
                    this.onChanged();
                }
                return data;
            }

            @Override
            public boolean exists() {
                if (!PerWorldHandler.this.chunkCustomData.containsKey(id)) {
                    return false;
                }
                return PerWorldHandler.this.chunkCustomData.get(id).containsKey(new ChunkPos(pos));
            }

            @Override
            public void onChanged() {
                PerWorldHandler.this.func_76185_a();
            }

            @Override
            public void remove() {
                Map<ChunkPos, NBTTagCompound> counters = PerWorldHandler.this.chunkCustomData.get(id);
                if (counters == null) {
                    return;
                }
                counters.remove(new ChunkPos(pos));
                this.onChanged();
                if (counters.isEmpty()) {
                    PerWorldHandler.this.chunkCustomData.remove(id);
                }
            }
        };
    }

    @Override
    public void markBlockAsUnbreakable(String id, BlockPos pos) {
        Set<String> set = this.unbreakables.get(pos);
        if (set == null) {
            set = new LinkedHashSet<String>();
            this.unbreakables.put(pos, set);
        }
        set.add(id);
        this.func_76185_a();
    }

    @Override
    public void removeBlockUnbreaking(String id, BlockPos pos) {
        Set<String> set = this.unbreakables.get(pos);
        if (set == null) {
            return;
        }
        if (set.remove(id)) {
            if (set.isEmpty()) {
                this.unbreakables.remove(pos);
            }
            this.func_76185_a();
        }
    }

    @Override
    public void removeBlockUnbreaking(BlockPos pos) {
        this.unbreakables.remove(pos);
        this.func_76185_a();
    }

    @Override
    public boolean isUnbreakable(BlockPos pos, IBlockState state) {
        Set<String> set = this.unbreakables.get(pos);
        if (set == null) {
            return false;
        }
        Iterator<String> iter = set.iterator();
        while (iter.hasNext()) {
            IBlockResource res = ScavengeHandler.INSTANCE.getResource(iter.next());
            if (res == null) {
                iter.remove();
                continue;
            }
            if (res.blockMatches(state)) continue;
            iter.remove();
        }
        return set.size() > 0;
    }

    public void func_76184_a(NBTTagCompound compound) {
        NBTTagCompound data;
        int y;
        NBTTagList subList;
        LinkedHashMap<Object, IntCounter> map;
        NBTTagCompound nbt;
        int i;
        this.counters.clear();
        this.blockCounters.clear();
        this.chunkCounters.clear();
        this.customData.clear();
        this.blockCustomData.clear();
        this.chunkCustomData.clear();
        this.unbreakables.clear();
        NBTTagList list = compound.func_150295_c("Counters", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            nbt = list.func_150305_b(i);
            this.counters.put(nbt.func_74779_i("K"), new IntCounter(nbt.func_74762_e("V")));
        }
        list = compound.func_150295_c("BlockCounters", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            nbt = list.func_150305_b(i);
            map = new LinkedHashMap<Object, IntCounter>();
            subList = nbt.func_150295_c("V", 10);
            for (y = 0; y < subList.func_74745_c(); ++y) {
                data = subList.func_150305_b(y);
                map.put(BlockPos.func_177969_a((long)data.func_74763_f("K")), new IntCounter(data.func_74762_e("V")));
            }
            this.blockCounters.put(nbt.func_74779_i("K"), map);
        }
        list = compound.func_150295_c("ChunkCounters", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            nbt = list.func_150305_b(i);
            map = new LinkedHashMap();
            subList = nbt.func_150295_c("V", 10);
            for (y = 0; y < subList.func_74745_c(); ++y) {
                data = subList.func_150305_b(y);
                map.put(new ChunkPos(BlockPos.func_177969_a((long)data.func_74763_f("K"))), new IntCounter(data.func_74762_e("V")));
            }
            this.chunkCounters.put(nbt.func_74779_i("K"), map);
        }
        list = compound.func_150295_c("CustomData", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            nbt = list.func_150305_b(i);
            this.customData.put(nbt.func_74779_i("K"), nbt.func_74775_l("V"));
        }
        list = compound.func_150295_c("BlockCustomData", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            nbt = list.func_150305_b(i);
            map = new LinkedHashMap();
            subList = nbt.func_150295_c("V", 10);
            for (y = 0; y < subList.func_74745_c(); ++y) {
                data = subList.func_150305_b(y);
                map.put(BlockPos.func_177969_a((long)data.func_74763_f("K")), (IntCounter)data.func_74775_l("V"));
            }
            this.blockCustomData.put(nbt.func_74779_i("K"), map);
        }
        list = compound.func_150295_c("ChunkCustomData", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            nbt = list.func_150305_b(i);
            map = new LinkedHashMap();
            subList = nbt.func_150295_c("V", 10);
            for (y = 0; y < subList.func_74745_c(); ++y) {
                data = subList.func_150305_b(y);
                map.put(new ChunkPos(BlockPos.func_177969_a((long)data.func_74763_f("K"))), (IntCounter)data.func_74775_l("V"));
            }
            this.chunkCustomData.put(nbt.func_74779_i("K"), map);
        }
        list = compound.func_150295_c("Unbreakables", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            nbt = list.func_150305_b(i);
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            subList = nbt.func_150295_c("V", 8);
            for (y = 0; y < subList.func_74745_c(); ++y) {
                set.add(subList.func_150307_f(y));
            }
            this.unbreakables.put(BlockPos.func_177969_a((long)nbt.func_74763_f("K")), set);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagCompound nbt;
        Object nbt2;
        NBTTagList subList;
        NBTTagList list = new NBTTagList();
        for (Map.Entry<String, IntCounter> entry : this.counters.entrySet()) {
            NBTTagCompound nbt3 = new NBTTagCompound();
            nbt3.func_74778_a("K", entry.getKey());
            nbt3.func_74768_a("V", entry.getValue().getCurrentValue());
            list.func_74742_a((NBTBase)nbt3);
        }
        compound.func_74782_a("Counters", (NBTBase)list);
        list = new NBTTagList();
        for (Map.Entry<String, Object> entry : this.blockCounters.entrySet()) {
            subList = new NBTTagList();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                NBTTagCompound nbt22 = new NBTTagCompound();
                nbt22.func_74772_a("K", ((BlockPos)entry2.getKey()).func_177986_g());
                nbt22.func_74768_a("V", ((IntCounter)entry2.getValue()).getCurrentValue());
                subList.func_74742_a((NBTBase)nbt22);
            }
            nbt2 = new NBTTagCompound();
            nbt2.func_74778_a("K", entry.getKey());
            nbt2.func_74782_a("V", (NBTBase)subList);
            list.func_74742_a((NBTBase)nbt2);
        }
        compound.func_74782_a("BlockCounters", (NBTBase)list);
        list = new NBTTagList();
        for (Map.Entry<String, Object> entry : this.chunkCounters.entrySet()) {
            subList = new NBTTagList();
            for (Map.Entry entry3 : ((Map)entry.getValue()).entrySet()) {
                nbt = new NBTTagCompound();
                nbt.func_74772_a("K", ((ChunkPos)entry3.getKey()).func_180331_a(7, 0, 7).func_177986_g());
                nbt.func_74768_a("V", ((IntCounter)entry3.getValue()).getCurrentValue());
                subList.func_74742_a((NBTBase)nbt);
            }
            nbt2 = new NBTTagCompound();
            nbt2.func_74778_a("K", entry.getKey());
            nbt2.func_74782_a("V", (NBTBase)subList);
            list.func_74742_a((NBTBase)nbt2);
        }
        compound.func_74782_a("ChunkCounters", (NBTBase)list);
        list = new NBTTagList();
        for (Map.Entry<String, Object> entry : this.customData.entrySet()) {
            NBTTagCompound nbt3 = new NBTTagCompound();
            nbt3.func_74778_a("K", entry.getKey());
            nbt3.func_74782_a("V", (NBTBase)((NBTTagCompound)entry.getValue()).func_74737_b());
            list.func_74742_a((NBTBase)nbt3);
        }
        compound.func_74782_a("CustomData", (NBTBase)list);
        list = new NBTTagList();
        for (Map.Entry<String, Object> entry : this.blockCustomData.entrySet()) {
            subList = new NBTTagList();
            for (Map.Entry entry4 : ((Map)entry.getValue()).entrySet()) {
                nbt = new NBTTagCompound();
                nbt.func_74772_a("K", ((BlockPos)entry4.getKey()).func_177986_g());
                nbt.func_74782_a("V", (NBTBase)((NBTTagCompound)entry4.getValue()).func_74737_b());
                subList.func_74742_a((NBTBase)nbt);
            }
            nbt2 = new NBTTagCompound();
            nbt2.func_74778_a("K", entry.getKey());
            nbt2.func_74782_a("V", (NBTBase)subList);
            list.func_74742_a((NBTBase)nbt2);
        }
        compound.func_74782_a("BlockCustomData", (NBTBase)list);
        list = new NBTTagList();
        for (Map.Entry<String, Object> entry : this.chunkCustomData.entrySet()) {
            subList = new NBTTagList();
            for (Map.Entry entry5 : ((Map)entry.getValue()).entrySet()) {
                nbt = new NBTTagCompound();
                nbt.func_74772_a("K", ((ChunkPos)entry5.getKey()).func_180331_a(7, 0, 7).func_177986_g());
                nbt.func_74782_a("V", (NBTBase)((NBTTagCompound)entry5.getValue()).func_74737_b());
                subList.func_74742_a((NBTBase)nbt);
            }
            nbt2 = new NBTTagCompound();
            nbt2.func_74778_a("K", entry.getKey());
            nbt2.func_74782_a("V", (NBTBase)subList);
            list.func_74742_a((NBTBase)nbt2);
        }
        compound.func_74782_a("ChunkCustomData", (NBTBase)list);
        list = new NBTTagList();
        for (Map.Entry<String, Object> entry : this.unbreakables.entrySet()) {
            subList = new NBTTagList();
            for (String string : (Set)entry.getValue()) {
                subList.func_74742_a((NBTBase)new NBTTagString(string));
            }
            nbt2 = new NBTTagCompound();
            nbt2.func_74772_a("K", ((BlockPos)entry.getKey()).func_177986_g());
            nbt2.func_74782_a("V", (NBTBase)subList);
            list.func_74742_a((NBTBase)nbt2);
        }
        compound.func_74782_a("Unbreakables", (NBTBase)list);
        return compound;
    }
}

