/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.handlers;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import scavenge.api.IClientRegistry;

public class ClientRegistry
implements IClientRegistry {
    Map<String, List<ToolClass>> classes = new LinkedHashMap<String, List<ToolClass>>();

    public void init() {
        for (Item item : Item.field_150901_e) {
            NonNullList list = NonNullList.func_191196_a();
            item.func_150895_a(CreativeTabs.field_78027_g, list);
            for (ItemStack stack : list) {
                Set keys = item.getToolClasses(stack);
                if (keys == null || keys.isEmpty()) continue;
                for (String tool : keys) {
                    int level = item.getHarvestLevel(stack, tool, null, null);
                    if (level < 0) continue;
                    this.add(tool, new ToolClass(stack, level));
                }
            }
        }
    }

    private void add(String type, ToolClass clz) {
        List<ToolClass> list = this.classes.get(type);
        if (list == null) {
            list = new ArrayList<ToolClass>();
            this.classes.put(type, list);
        }
        list.add(clz);
    }

    @Override
    public List<ItemStack> getTools(String tool, int level) {
        List<ToolClass> list = this.classes.get(tool);
        if (list == null) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ToolClass entry : list) {
            if (entry.getLevel() < level) continue;
            result.add(entry.getStack());
        }
        return result;
    }

    public static class ToolClass {
        ItemStack stack;
        int level;

        public ToolClass(ItemStack stack, int level) {
            this.stack = stack;
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }

        public ItemStack getStack() {
            return this.stack;
        }
    }
}

