/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import scavenge.api.ScavengeAPI;
import scavenge.core.command.ScavengeCommand;
import scavenge.core.handlers.ClientRegistry;
import scavenge.core.handlers.MathRegistry;
import scavenge.core.handlers.ScavengeHandler;
import scavenge.core.handlers.WorldRegistry;
import scavenge.core.loaders.DocumentationExporter;
import scavenge.core.loaders.IncompatLoader;
import scavenge.core.loaders.NBTLoader;
import scavenge.core.loaders.PluginLoader;
import scavenge.core.loaders.ScriptLoader;
import scavenge.core.math.ScavengeMath;

@Mod(modid="scavenge", version="1.8", name="Scavenge", acceptedMinecraftVersions="[1.12]")
public class Scavenge {
    public static Scavenge instance;
    Configuration config;
    public File configFolder;
    HashMap<String, List<String>> errorMap = new LinkedHashMap<String, List<String>>();
    NBTLoader loader = new NBTLoader();
    public ScriptLoader scripts = new ScriptLoader();
    PluginLoader plugins = new PluginLoader();
    public IncompatLoader incompat = new IncompatLoader();
    public DocumentationExporter doc = new DocumentationExporter();
    List<File> nbtFiles = new ArrayList<File>();
    List<File> files = new ArrayList<File>();
    ClientRegistry clientData = new ClientRegistry();

    public Scavenge() {
        instance = this;
    }

    @Mod.EventHandler
    public void onPreLoad(FMLPreInitializationEvent evt) {
        ScavengeAPI.INSTANCE.setMathRegistry(new MathRegistry());
        ScavengeAPI.INSTANCE.setWorldRegistry(new WorldRegistry());
        ScavengeAPI.INSTANCE.setClientRegistry(this.clientData);
        this.configFolder = new File(evt.getModConfigurationDirectory(), "scavenge");
        this.config = new Configuration(new File(this.configFolder, "config.cfg"));
        this.plugins.loadPlugins(evt.getAsmData(), this.config);
        ScavengeHandler.INSTANCE.init();
        this.reloadConfigs(false);
        ScavengeMath.INSTANCE.register(ScavengeAPI.INSTANCE);
        this.plugins.loadPlugins();
        ScavengeAPI.printDocumentation = this.config.get("general", "printDocumentation", false).getBoolean();
        ScavengeAPI.printInCurseFormat = this.config.get("general", "printDocumentationInCurseFormat", false).getBoolean();
        this.config.save();
    }

    @Mod.EventHandler
    public void onPostLoad(FMLPostInitializationEvent evt) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.clientData.init();
        }
        this.plugins.postLoadPlugin();
        this.incompat.loadIncompats(ScavengeAPI.INSTANCE);
        if (ScavengeAPI.printDocumentation) {
            this.doc.export(ScavengeAPI.INSTANCE, this.configFolder, this.incompat, ScavengeAPI.printInCurseFormat);
        }
        this.reload();
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new ScavengeCommand());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadConfigs(boolean reload) {
        this.files.clear();
        this.nbtFiles.clear();
        try {
            File entry;
            int i;
            if (reload) {
                this.config.load();
            }
            String[] array = this.config.getStringList("LoadingFiles", "general", new String[0], "Selects the files that are being loaded");
            for (i = 0; i < array.length; ++i) {
                entry = new File(this.configFolder, array[i]);
                if (!entry.exists()) continue;
                this.files.add(entry);
            }
            array = this.config.getStringList("NBTFiles", "general", new String[0], "Selects the files that load into the NBTStorage");
            for (i = 0; i < array.length; ++i) {
                entry = new File(this.configFolder, array[i]);
                if (!entry.exists()) continue;
                this.nbtFiles.add(entry);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.config.save();
        }
        if (reload) {
            this.reload();
        }
    }

    public void reload() {
        ScavengeHandler.INSTANCE.clear();
        ScavengeAPI.INSTANCE.clearTemporaryStorage();
        this.errorMap.clear();
        for (File file : this.nbtFiles) {
            this.loader.loadNBTFiles(file);
            if (!this.loader.hasErrors()) continue;
            this.errorMap.put(file.getName(), this.loader.getErrors());
        }
        for (File file : this.files) {
            this.scripts.loadFile(this.toText(file), file.getName());
            if (!this.scripts.hasErros()) continue;
            this.errorMap.put(file.getName(), this.scripts.getErrors());
        }
        if (this.errorMap.size() > 0) {
            for (Map.Entry entry : this.errorMap.entrySet()) {
                FMLLog.getLogger().info("Errors for File: " + (String)entry.getKey());
                for (String s : (List)entry.getValue()) {
                    FMLLog.getLogger().info(s);
                }
            }
        }
    }

    public String toText(File file) {
        try {
            return Files.toString((File)file, (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public void printToChat(ICommandSender sender) {
        if (this.errorMap.size() > 0) {
            for (Map.Entry<String, List<String>> error : this.errorMap.entrySet()) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Errors for File: " + error.getKey()));
                for (String s : error.getValue()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(s));
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("No Errors Found!"));
        }
    }
}

