/*
 * Decompiled with CFR 0.152.
 */
package scavenge.api.block.impl;

import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import scavenge.api.ScavengeAPI;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceProperty;
import scavenge.api.utils.JsonUtil;
import scavenge.api.world.IWorldHandler;

public abstract class BaseResourceProperty
implements IResourceProperty {
    String jeiInfo;
    boolean jei;
    String id;
    Set<String> incompats = new HashSet<String>();

    public BaseResourceProperty(JsonObject obj, String id) {
        this(!JsonUtil.getOrDefault(obj, "disableJEI", false), id);
    }

    public BaseResourceProperty(boolean jei, String id) {
        this.jei = jei;
        this.id = id;
    }

    public void addSelfIncompat() {
        this.incompats.add(this.id);
    }

    public void setJEIInfo(String s) {
        this.jeiInfo = s;
    }

    public void addIncompat(String id) {
        this.incompats.add(id);
    }

    public void addIncompats(String ... ids) {
        for (String id : ids) {
            this.incompats.add(id.toLowerCase(Locale.ENGLISH));
        }
    }

    @Override
    public void addJEIData(IResourceProperty.IJEIBlockHandler collector) {
        if (this.jei) {
            collector.addInfo(this.jeiInfo);
        }
    }

    @Override
    public boolean canCombine(IResourceProperty property) {
        return this.incompats.isEmpty() || !this.incompats.contains(property.getID().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public boolean shouldShowInJEI() {
        return this.jei;
    }

    public void sendPacketToPlayer(EntityPlayer player, Packet packet) {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP mp = (EntityPlayerMP)player;
            if (mp.field_71135_a == null) {
                return;
            }
            mp.field_71135_a.func_147359_a(packet);
        }
    }

    public IWorldHandler getHandler(World world) {
        return ScavengeAPI.INSTANCE.getWorldRegistry().getStorageForWorld(world);
    }

    protected IResourceCondition createCondition(JsonObject obj) {
        String id = obj.get("type").getAsString();
        IResourceProperty prop = ScavengeAPI.INSTANCE.createResourceProperty(id, obj);
        if (prop instanceof IResourceCondition) {
            return (IResourceCondition)prop;
        }
        throw new RuntimeException("Property [" + id + "] is not a condition!");
    }

    protected IResourceEffect createEffect(JsonObject obj) {
        String id = obj.get("type").getAsString();
        IResourceProperty prop = ScavengeAPI.INSTANCE.createResourceProperty(id, obj);
        if (prop instanceof IResourceEffect) {
            return (IResourceEffect)prop;
        }
        throw new RuntimeException("Property [" + id + "] is not a Effect!");
    }

    protected StatisticsManager getStats(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            return ((EntityPlayerMP)player).func_147099_x();
        }
        return this.getClientStats(player);
    }

    @SideOnly(value=Side.CLIENT)
    protected StatisticsManager getClientStats(EntityPlayer player) {
        if (player instanceof EntityPlayerSP) {
            return ((EntityPlayerSP)player).func_146107_m();
        }
        return null;
    }
}

