/*
 * Decompiled with CFR 0.152.
 */
package scavenge.api.autodoc;

import java.io.BufferedWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import scavenge.api.autodoc.BaseElement;

public class MapElement
extends BaseElement<String> {
    Map<String, BaseElement> elementMap = new LinkedHashMap<String, BaseElement>();
    boolean isDocumentation = false;

    public MapElement(String id) {
        super(id);
        this.setType("Object");
    }

    public MapElement addElement(BaseElement element) {
        this.elementMap.put(element.getKey(), element);
        return this;
    }

    public void setDocumentationState(boolean value) {
        this.isDocumentation = value;
    }

    @Override
    public boolean isMultiElement() {
        return false;
    }

    @Override
    public String getValue() {
        return "";
    }

    @Override
    public void writeToBuffer(BufferedWriter writer, boolean showSelf, int layer, boolean printCurse) throws Exception {
        if (printCurse) {
            if (this.isDocumentation) {
                writer.write(this.getOffset(layer) + "<strong>Description</strong>: " + this.getDescription());
                writer.write("<br />");
                writer.newLine();
                if (this.elementMap.size() > 0) {
                    writer.write(this.getOffset(layer) + "<strong>Parameters</strong>:");
                    writer.write("<br />");
                    writer.newLine();
                }
            }
            if (showSelf) {
                writer.write(this.getOffset(layer) + "<strong>\"" + this.key + "\"</strong>: (" + this.getDescription() + ") " + this.getType() + ",");
                writer.write("<br />");
                writer.newLine();
            }
        } else {
            if (this.isDocumentation) {
                writer.write(this.getOffset(layer) + "Description: " + this.getDescription());
                writer.newLine();
                if (this.elementMap.size() > 0) {
                    writer.write(this.getOffset(layer) + "Parameters:");
                    writer.newLine();
                }
            }
            if (showSelf) {
                writer.write(this.getOffset(layer) + "\"" + this.key + "\": (" + this.getDescription() + ") " + this.getType() + ",");
                writer.newLine();
            }
        }
        for (BaseElement el : this.elementMap.values()) {
            el.writeToBuffer(writer, true, layer + 1, printCurse);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator<BaseElement> iter = this.elementMap.values().iterator();
        while (iter.hasNext()) {
            builder.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        return "Map[id=" + this.key + ",value=(" + builder.toString() + ")]";
    }
}

