/*
 * Decompiled with CFR 0.152.
 */
package scavenge.api.autodoc;

import java.io.BufferedWriter;

public abstract class BaseElement<T> {
    String key;
    String description = "";
    T defaultValue;
    boolean hasDefaultValue = false;
    String type;

    public BaseElement(String id) {
        this.key = id;
    }

    public String getKey() {
        return this.key;
    }

    public BaseElement setDefaultValue(T value) {
        this.defaultValue = value;
        this.hasDefaultValue = value != null;
        return this;
    }

    public BaseElement setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public String getType() {
        return this.type;
    }

    public BaseElement setType(String type) {
        this.type = type;
        return this;
    }

    public boolean hasDefaultValue() {
        return this.hasDefaultValue;
    }

    public abstract T getValue();

    public abstract boolean isMultiElement();

    public void writeToBuffer(BufferedWriter writer, boolean showSelf, int layer, boolean printCurse) throws Exception {
        if (printCurse) {
            if (this.hasDefaultValue()) {
                writer.write(this.getOffset(layer) + "<strong>\"" + this.key + "\"</strong>: (" + this.getDescription() + ", Default: " + this.getDefaultValue().toString() + ") " + this.getType() + ",");
            } else {
                writer.write(this.getOffset(layer) + "<strong>\"" + this.key + "\"</strong>: (" + this.getDescription() + ") " + this.getType() + ",");
            }
            writer.write("<br />");
        } else if (this.hasDefaultValue()) {
            writer.write(this.getOffset(layer) + "\"" + this.key + "\": (" + this.getDescription() + ", Default: " + this.getDefaultValue().toString() + ") " + this.getType() + ",");
        } else {
            writer.write(this.getOffset(layer) + "\"" + this.key + "\": (" + this.getDescription() + ") " + this.getType() + ",");
        }
        writer.newLine();
    }

    protected String getOffset(int layer) {
        if (layer <= 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < layer; ++i) {
            builder.append("   ");
        }
        return builder.toString();
    }

    public abstract String toString();
}

