/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dshuds.compat;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dshuds.compat.SeasonType;
import org.orecruncher.lib.Localization;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.SeasonHelper;

@SideOnly(value=Side.CLIENT)
public class SereneSeasonHandler
implements Function<World, String> {
    protected static final String noSeason = Localization.loadString((String)"dshuds.season.noseason");

    @Override
    public String apply(@Nonnull World world) {
        ISeasonState ss = SeasonHelper.getSeasonState((World)world);
        SeasonType season = SeasonType.getSeasonType(ss);
        if (season == SeasonType.NONE) {
            return noSeason;
        }
        SeasonType.SubType sub = SeasonType.getSeasonSubType(ss);
        String seasonStr = Localization.loadString((String)("dshuds.season." + season.getValue()));
        String subSeasonStr = Localization.loadString((String)("dshuds.season." + sub.getValue()));
        return Localization.format((String)"dshuds.season.format", (Object[])new Object[]{subSeasonStr, seasonStr});
    }
}

