/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dshuds;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.orecruncher.dshuds.compat.SereneSeasonHandler;
import org.orecruncher.lib.MinecraftClock;

@Mod.EventBusSubscriber(modid="dshuds")
public final class Environment {
    private static final MinecraftClock clock = new MinecraftClock();
    private static final BlockPos.MutableBlockPos playerPosition = new BlockPos.MutableBlockPos();
    private static final Function<World, String> seasonStringHandler;
    private static int tickCount;
    private static String biomeName;
    private static String seasonString;

    public static int getTickCounter() {
        return tickCount;
    }

    @Nullable
    public static World getWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Nullable
    public static EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Nonnull
    public static MinecraftClock getClock() {
        return clock;
    }

    @Nonnull
    public static BlockPos getPlayerPosition() {
        return playerPosition;
    }

    @Nonnull
    public static String getBiomeName() {
        return biomeName;
    }

    @Nonnull
    public static String getSeasonString() {
        return seasonString;
    }

    @SubscribeEvent
    public static void clientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && Environment.getPlayer() != null && Environment.getWorld() != null) {
            ++tickCount;
            clock.update(Environment.getWorld());
            playerPosition.func_189535_a((Entity)Environment.getPlayer());
            biomeName = Environment.getWorld().func_180494_b((BlockPos)playerPosition).func_185359_l();
            seasonString = seasonStringHandler.apply(Environment.getWorld());
        }
    }

    static {
        tickCount = 0;
        biomeName = "";
        seasonString = "";
        seasonStringHandler = Loader.isModLoaded((String)"sereneseasons") ? new SereneSeasonHandler() : world -> "";
    }
}

