/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.debark.util;

import com.google.common.collect.ImmutableList;
import java.awt.image.BufferedImage;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public final class ModelDataLookup {
    private static final List<int[][]> fakeTextureFrameList = ImmutableList.of((Object)new int[1][256]);
    public static final BufferedImage missingNo = new BufferedImage(16, 16, 2);

    private ModelDataLookup() {
    }

    public static ResourceLocation getLocation(IBlockState state, EnumFacing facing, IModel model) {
        String variant;
        IProperty variantProp;
        String[] name;
        String domain = state.func_177230_c().getRegistryName().func_110624_b();
        if ("forestry".equals(domain)) {
            name = state.func_177230_c().getRegistryName().func_110623_a().split("\\.", 2);
            variantProp = state.func_177230_c().func_176194_O().func_185920_a("variant");
            if (variantProp != null) {
                variant = variantProp.func_177702_a(state.func_177229_b(variantProp));
                if (name.length == 2) {
                    switch (name[0]) {
                        case "planks": {
                            return new ResourceLocation("forestry", "blocks/wood/planks." + variant);
                        }
                        case "logs": {
                            if (facing.func_176740_k() == EnumFacing.Axis.Y) {
                                return new ResourceLocation("forestry", "blocks/wood/heart." + variant);
                            }
                            return new ResourceLocation("forestry", "blocks/wood/bark." + variant);
                        }
                    }
                }
            }
        } else if ("extratrees".equals(domain)) {
            name = state.func_177230_c().getRegistryName().func_110623_a().split("\\.", 2);
            variantProp = state.func_177230_c().func_176194_O().func_185920_a("variant");
            if (variantProp != null) {
                variant = variantProp.func_177702_a(state.func_177229_b(variantProp));
                if (name.length == 2) {
                    switch (name[0]) {
                        case "planks": {
                            return new ResourceLocation("extratrees", "blocks/planks/" + variant);
                        }
                        case "logs": {
                            if (facing.func_176740_k() == EnumFacing.Axis.Y) {
                                return new ResourceLocation("extratrees", "blocks/logs/" + variant + "_trunk");
                            }
                            return new ResourceLocation("extratrees", "blocks/logs/" + variant + "_bark");
                        }
                    }
                }
            }
        }
        try {
            IBakedModel bakedModel = model.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, FakeSprite::new);
            List quadList = bakedModel.func_188616_a(state, facing, 0L);
            if (!quadList.isEmpty()) {
                return new ResourceLocation(((BakedQuad)quadList.iterator().next()).func_187508_a().func_94215_i());
            }
            quadList = bakedModel.func_188616_a(state, null, 0L);
            for (BakedQuad q : quadList) {
                if (q.func_178210_d() != EnumFacing.UP) continue;
                return new ResourceLocation(q.func_187508_a().func_94215_i());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return TextureMap.field_174945_f;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            missingNo.setRGB(i & 0xF, i >> 4, ((i ^ i >> 4) & 8) != 0 ? -16777216 : -65281);
        }
    }

    private static class FakeSprite
    extends TextureAtlasSprite {
        protected FakeSprite(ResourceLocation spriteName) {
            super(spriteName.toString());
            this.func_110966_b(16);
            this.func_110969_c(16);
            this.func_110971_a(16, 16, 0, 0, false);
            this.func_110968_a(fakeTextureFrameList);
        }
    }
}

