/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.debark.messy;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import pl.asie.debark.old.UCWColorspaceUtils;
import pl.asie.debark.util.CustomSprite;
import pl.asie.debark.util.SpriteUtils;

public class LogColoredSprite
extends CustomSprite {
    private final ResourceLocation base;
    private final ResourceLocation template;

    public LogColoredSprite(String spriteName, ResourceLocation base, ResourceLocation template) {
        super(spriteName);
        this.base = base;
        this.template = template;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableSet.of((Object)this.base, (Object)this.template);
    }

    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        TextureAtlasSprite baseTex = SpriteUtils.loadSpriteOrWarn(this.base, textureGetter);
        TextureAtlasSprite templateTex = SpriteUtils.loadSpriteOrWarn(this.template, textureGetter);
        float minL = Float.MAX_VALUE;
        float maxL = Float.MIN_VALUE;
        double A = 0.0;
        double B = 0.0;
        int count = 0;
        int offset = (baseTex.func_94211_a() + 7) / 8;
        int[] baseData = SpriteUtils.getFrameDataOrWarn(baseTex);
        for (int iy = offset; iy < baseTex.func_94216_b() - offset; ++iy) {
            for (int ix = offset; ix < baseTex.func_94211_a() - offset; ++ix) {
                int pixel = baseData[iy * baseTex.func_94211_a() + ix];
                float[] lab = UCWColorspaceUtils.XYZtoLAB(UCWColorspaceUtils.sRGBtoXYZ(UCWColorspaceUtils.fromInt(pixel)));
                if (lab[0] < minL) {
                    minL = lab[0];
                }
                if (lab[0] > maxL) {
                    maxL = lab[0];
                }
                A += (double)lab[1];
                B += (double)lab[2];
                ++count;
            }
        }
        assert (count >= 1);
        A /= (double)count;
        B /= (double)count;
        int[] templateData = new int[templateTex.func_94211_a() * templateTex.func_94216_b()];
        int[] templateInput = SpriteUtils.getFrameDataOrWarn(templateTex);
        for (int i = 0; i < templateData.length; ++i) {
            int oldPixel = templateInput[i];
            float[] scaledPixel = UCWColorspaceUtils.fromInt(oldPixel);
            float l = UCWColorspaceUtils.sRGBtoLuma(scaledPixel);
            l = (float)Math.pow(l / 100.0f, 2.2) * 100.0f;
            if ((l = (l / 50.0f - 1.0f) * (maxL - minL) + minL) < 0.0f) {
                l = 0.0f;
            } else if (l > 100.0f) {
                l = 100.0f;
            }
            float[] lab = new float[]{l, (float)A, (float)B};
            templateData[i] = UCWColorspaceUtils.asInt(UCWColorspaceUtils.XYZtosRGB(UCWColorspaceUtils.LABtoXYZ(lab))) | 0xFF000000;
        }
        this.func_110966_b(templateTex.func_94211_a());
        this.func_110969_c(templateTex.func_94216_b());
        this.addFrameTextureData(templateData);
        return false;
    }
}

