/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.debark.messy;

import com.google.common.collect.ImmutableSet;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import pl.asie.debark.old.UCWColorspaceUtils;
import pl.asie.debark.util.CustomSprite;

public class DebarkTopSprite
extends CustomSprite {
    private final ResourceLocation base;

    public DebarkTopSprite(String spriteName, ResourceLocation base) {
        super(spriteName);
        this.base = base;
    }

    @Override
    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableSet.of((Object)this.base);
    }

    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        BufferedImage baseImage;
        block22: {
            baseImage = null;
            try {
                List baseResource = manager.func_135056_b(new ResourceLocation(this.base.func_110624_b(), "textures/" + this.base.func_110623_a() + ".png"));
                if (baseResource.size() <= 0) break block22;
                try (InputStream stream = ((IResource)baseResource.get(0)).func_110527_b();){
                    baseImage = TextureUtil.func_177053_a((InputStream)stream);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (baseImage == null) {
            throw new RuntimeException("Could not load " + this.base + "!");
        }
        int[] templateData = new int[baseImage.getWidth() * baseImage.getHeight()];
        float minL = Float.MAX_VALUE;
        float maxL = Float.MIN_VALUE;
        for (int iy = 1; iy < baseImage.getHeight() - 1; ++iy) {
            for (int ix = 1; ix < baseImage.getWidth() - 1; ++ix) {
                int pixel = baseImage.getRGB(ix, iy);
                float lum = UCWColorspaceUtils.sRGBtoLuma(UCWColorspaceUtils.fromInt(pixel));
                if (lum < minL) {
                    minL = lum;
                }
                if (!(lum > maxL)) continue;
                maxL = lum;
            }
        }
        minL = (float)Math.pow(minL / 100.0f, 2.2) * 100.0f;
        maxL = (float)Math.pow(maxL / 100.0f, 2.2) * 100.0f;
        int ip = 0;
        Random predictableRandom = new Random(1337L);
        for (int iy = 0; iy < baseImage.getHeight(); ++iy) {
            int ix = 0;
            while (ix < baseImage.getWidth()) {
                boolean isBorder;
                boolean bl = isBorder = ix == 0 || iy == 0 || ix == baseImage.getWidth() - 1 || iy == baseImage.getHeight() - 1;
                if (isBorder) {
                    int luma = 96 + predictableRandom.nextInt(7);
                    templateData[ip] = luma * 65793 | 0xFF000000;
                } else {
                    int pixel = baseImage.getRGB(ix, iy);
                    float lum = UCWColorspaceUtils.sRGBtoLuma(UCWColorspaceUtils.fromInt(pixel));
                    lum = (float)Math.pow(lum / 100.0f, 2.2) * 100.0f;
                    lum = (lum - minL) / (maxL - minL) * 100.0f;
                    lum = lum / 2.0f + 50.0f;
                    lum = (float)Math.pow(lum / 100.0f, 0.45454545454545453) * 100.0f;
                    templateData[ip] = UCWColorspaceUtils.asInt(UCWColorspaceUtils.XYZtosRGB(UCWColorspaceUtils.LABtoXYZ(new float[]{lum, 0.0f, 0.0f}))) | 0xFF000000;
                }
                ++ix;
                ++ip;
            }
        }
        this.func_110966_b(baseImage.getWidth());
        this.func_110969_c(baseImage.getHeight());
        this.addFrameTextureData(templateData);
        return false;
    }
}

