/*
 * Decompiled with CFR 0.152.
 */
package guichaguri.betterfps.tweaker;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public enum Mappings {
    M_StaticBlock(Type.METHOD, "StaticBlock", "<clinit>"),
    M_Constructor(Type.METHOD, "Constructor", "<init>"),
    C_Minecraft(Type.CLASS, "Minecraft"),
    C_World(Type.CLASS, "World"),
    C_Chunk(Type.CLASS, "Chunk"),
    C_Block(Type.CLASS, "Block"),
    C_EntityPlayer(Type.CLASS, "EntityPlayer"),
    C_EntityPlayerSP(Type.CLASS, "EntityPlayerSP"),
    C_MathHelper(Type.CLASS, "MathHelper"),
    C_PrimedTNT(Type.CLASS, "EntityTNTPrimed"),
    C_ClientBrandRetriever(Type.CLASS, "ClientBrandRetriever"),
    C_GuiOptions(Type.CLASS, "GuiOptions"),
    C_WorldClient(Type.CLASS, "WorldClient"),
    C_WorldServer(Type.CLASS, "WorldServer"),
    C_IntegratedServer(Type.CLASS, "IntegratedServer"),
    C_DedicatedServer(Type.CLASS, "DedicatedServer"),
    C_TileEntityBeacon(Type.CLASS, "TileEntityBeacon"),
    C_TileEntityBeaconRenderer(Type.CLASS, "TileEntityBeaconRenderer"),
    C_BeamSegment(Type.CLASS, "TileEntityBeacon$BeamSegment"),
    C_TileEntityHopper(Type.CLASS, "TileEntityHopper"),
    C_BlockHopper(Type.CLASS, "BlockHopper"),
    C_ModelBox(Type.CLASS, "ModelBox"),
    C_EntityRenderer(Type.CLASS, "EntityRenderer"),
    C_IInventory(Type.CLASS, "IInventory"),
    C_GuiContainerCreative(Type.CLASS, "GuiContainerCreative"),
    C_RenderPlayer(Type.CLASS, "RenderPlayer"),
    M_startGame(Type.METHOD, "startGame"),
    M_sin(Type.METHOD, "sin"),
    M_cos(Type.METHOD, "cos"),
    M_tick(Type.METHOD, "tick"),
    M_onUpdate(Type.METHOD, "onUpdate"),
    M_updateBlocks(Type.METHOD, "updateBlocks"),
    M_getClientModName(Type.METHOD, "getClientModName"),
    M_freeMemory(Type.METHOD, "freeMemory"),
    M_initGui(Type.METHOD, "initGui"),
    M_startServer(Type.METHOD, "startServer"),
    M_captureDroppedItems(Type.METHOD, "captureDroppedItems"),
    M_getHopperInventory(Type.METHOD, "getHopperInventory"),
    F_memoryReserve(Type.FIELD, "memoryReserve"),
    F_SIN_TABLE(Type.FIELD, "SIN_TABLE");

    public final Type type;
    public final String identifier;
    protected String deobfName;
    protected String obfName;
    protected String ownerDeobfName;
    protected String ownerObfName;
    protected String deobfDesc;
    protected String obfDesc;

    public static void loadMappings(InputStream srg) throws IOException {
        List lines = IOUtils.readLines((InputStream)srg, (String)"UTF-8");
        for (String line : lines) {
            String[] m2 = line.split(" ");
            String identifier = m2[m2.length - 1];
            for (Mappings mp : Mappings.values()) {
                if (m2[0].equals("CL:")) {
                    if (m2.length < 4 || mp.type != Type.CLASS || !mp.identifier.equals(identifier)) continue;
                    mp.deobfName = m2[2];
                    mp.obfName = m2[1];
                    continue;
                }
                if (m2[0].equals("FD:")) {
                    if (m2.length < 4 || mp.type != Type.FIELD || !mp.identifier.equals(identifier)) continue;
                    Mappings.loadNames(m2, mp, 2, 1);
                    continue;
                }
                if (!m2[0].equals("MD:") || m2.length < 6 || mp.type != Type.METHOD || !mp.identifier.equals(identifier)) continue;
                Mappings.loadNames(m2, mp, 3, 1);
                mp.deobfDesc = m2[4];
                mp.obfDesc = m2[2];
            }
        }
    }

    private static void loadNames(String[] m2, Mappings mp, int deobf, int obf) {
        Object[] name = m2[deobf].split("/");
        mp.deobfName = name[name.length - 1];
        mp.ownerDeobfName = StringUtils.join((Object[])name, (String)"/", (int)0, (int)(name.length - 1));
        name = m2[obf].split("/");
        mp.obfName = name[name.length - 1];
        mp.ownerObfName = StringUtils.join((Object[])name, (String)"/", (int)0, (int)(name.length - 1));
    }

    private Mappings(Type type, String identifier) {
        this.type = type;
        this.identifier = identifier;
    }

    private Mappings(Type type, String identifier, String name) {
        this(type, identifier);
        this.deobfName = name;
        this.obfName = name;
    }

    public boolean is(String n) {
        return this.deobfName.equals(n = n.replaceAll("\\.", "/")) || this.obfName.equals(n);
    }

    public boolean isObf(String n) {
        return !this.deobfName.equals(this.obfName) && this.obfName.equals(n.replaceAll("\\.", "/"));
    }

    public boolean isDesc(String n) {
        return this.deobfDesc != null && n.equals(this.deobfDesc) || this.obfDesc != null && n.equals(this.obfDesc);
    }

    public boolean isOwner(String n) {
        n = n.replaceAll("\\.", "/");
        return this.ownerDeobfName == null || this.ownerObfName == null || n.equals(this.ownerDeobfName) || n.equals(this.ownerObfName);
    }

    public boolean is(String n, String d) {
        return this.is(n) && this.isDesc(d);
    }

    public boolean is(MethodNode method) {
        return (method.name.equals(this.deobfName) || method.name.equals(this.obfName)) && this.isDesc(method.desc);
    }

    public boolean is(FieldNode field) {
        return (field.name.equals(this.deobfName) || field.name.equals(this.obfName)) && this.isDesc(field.desc);
    }

    public boolean is(MethodInsnNode method) {
        return this.is(method.name) && this.isDesc(method.desc) && this.isOwner(method.owner);
    }

    public boolean is(FieldInsnNode field) {
        return this.is(field.name) && this.isDesc(field.desc) && this.isOwner(field.owner);
    }

    public String toString() {
        return this.identifier;
    }

    static enum Type {
        CLASS,
        METHOD,
        FIELD;

    }
}

