/*
 * Decompiled with CFR 0.152.
 */
package guichaguri.betterfps.gui.data;

import guichaguri.betterfps.BetterFpsConfig;
import guichaguri.betterfps.BetterFpsHelper;
import guichaguri.betterfps.gui.GuiConfigOption;
import guichaguri.betterfps.tweaker.BetterFpsTweaker;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class AlgorithmAction
implements Runnable {
    private final GuiConfigOption<BetterFpsConfig.AlgorithmType> button;
    private Thread thread;
    private Process process;

    public AlgorithmAction(GuiConfigOption<BetterFpsConfig.AlgorithmType> button) {
        this.button = button;
    }

    private String getJavaDir() {
        String separator = System.getProperty("file.separator");
        String path = System.getProperty("java.home") + separator + "bin" + separator;
        if (h.a() == h.a.c && new File(path + "javaw.exe").isFile()) {
            return path + "javaw.exe";
        }
        return path + "java";
    }

    private BetterFpsConfig.AlgorithmType parseAlgorithm(String algorithm) {
        if (algorithm == null) {
            return null;
        }
        if (algorithm.equals("java")) {
            return BetterFpsConfig.AlgorithmType.JAVA;
        }
        if (algorithm.equals("rivens")) {
            return BetterFpsConfig.AlgorithmType.RIVENS;
        }
        if (algorithm.equals("rivens-full")) {
            return BetterFpsConfig.AlgorithmType.RIVENS_FULL;
        }
        if (algorithm.equals("rivens-half")) {
            return BetterFpsConfig.AlgorithmType.RIVENS_HALF;
        }
        if (algorithm.equals("libgdx")) {
            return BetterFpsConfig.AlgorithmType.LIBGDX;
        }
        if (algorithm.equals("taylors")) {
            return BetterFpsConfig.AlgorithmType.TAYLORS;
        }
        if (algorithm.equals("vanilla")) {
            return BetterFpsConfig.AlgorithmType.VANILLA;
        }
        return null;
    }

    @Override
    public void run() {
        if (this.process != null && this.thread != null && this.thread.isAlive()) {
            return;
        }
        BetterFpsHelper.LOG.info("Benchmarking algorithms...");
        this.button.setTitle(cey.a((String)"betterfps.installer.algorithm.working", (Object[])new Object[0]));
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getJavaDir());
        args.add("-cp");
        args.add(BetterFpsTweaker.class.getProtectionDomain().getCodeSource().getLocation().getFile());
        args.add("guichaguri.betterfps.installer.GuiAlgorithmTester");
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AlgorithmAction.this.process.waitFor();
                    BufferedReader in = new BufferedReader(new InputStreamReader(AlgorithmAction.this.process.getInputStream()));
                    String line = in.readLine();
                    BetterFpsHelper.LOG.info("Benchmark is done.");
                    AlgorithmAction.this.button.setValue(AlgorithmAction.this.parseAlgorithm(line));
                    AlgorithmAction.this.button.updateTitle();
                    AlgorithmAction.this.process.destroy();
                    AlgorithmAction.this.process = null;
                    AlgorithmAction.this.thread = null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        try {
            this.process = new ProcessBuilder(args).start();
            this.thread.start();
        }
        catch (IOException ex) {
            BetterFpsHelper.LOG.error("Couldn't launch the benchmark", (Throwable)ex);
        }
    }
}

