/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.util;

import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class NBTUtils {
    private NBTUtils() {
    }

    @Nullable
    public static NBTTagCompound wrapCompound(@Nullable NBTTagCompound inner, String ... path) {
        if (inner == null) {
            return null;
        }
        return NBTUtils.setInnerCompound(new NBTTagCompound(), inner, path);
    }

    public static NBTTagCompound setInnerCompound(NBTTagCompound root, NBTTagCompound inner, String ... path) {
        NBTTagCompound nbt = root;
        for (int index = 0; index < path.length - 1; ++index) {
            String key = path[index];
            if (!nbt.func_150297_b(key, 10)) {
                nbt.func_74782_a(key, (NBTBase)new NBTTagCompound());
            }
            nbt = nbt.func_74775_l(key);
        }
        nbt.func_74782_a(path[path.length - 1], (NBTBase)inner);
        return root;
    }

    public static NBTTagCompound getPatch(NBTTagCompound from, NBTTagCompound to) {
        NBTTagCompound patch = new NBTTagCompound();
        Set keys = from.func_150296_c();
        for (String key : keys) {
            NBTBase t;
            NBTBase f = from.func_74781_a(key);
            if (!to.func_74764_b(key) || f.equals((Object)(t = to.func_74781_a(key)))) continue;
            patch.func_74782_a(key, t);
        }
        return patch;
    }
}

