/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.util;

import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.container.IWidgetContainer;
import com.mcmoddev.lib.container.MMDContainer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class LoggingUtil {
    private static final String LOGGING_ID = "__logging_id__";
    private static long currentId = 0L;

    private LoggingUtil() {
    }

    public static boolean isExtraLoggingEnabled() {
        return true;
    }

    public static void logNbtMessage(String reason, @Nullable NBTBase nbt) {
        LoggingUtil.logNbtMessage(null, reason, nbt);
    }

    public static void logNbtMessage(@Nullable Object sender, String reason, @Nullable NBTBase nbt) {
        if (!LoggingUtil.isExtraLoggingEnabled()) {
            return;
        }
        StringBuilder log = new StringBuilder();
        if (nbt instanceof NBTTagCompound) {
            long id;
            NBTTagCompound compound = (NBTTagCompound)nbt;
            if (compound.func_150297_b(LOGGING_ID, 4)) {
                id = compound.func_74763_f(LOGGING_ID);
            } else if (!nbt.func_82582_d()) {
                id = currentId++;
                compound.func_74772_a(LOGGING_ID, id);
            } else {
                id = -1L;
            }
            log.append("#");
            log.append(id);
            log.append(" ");
        }
        if (sender instanceof TileEntity) {
            LoggingUtil.appendTileEntityInfo(log, (TileEntity)sender);
        } else if (sender instanceof MMDContainer) {
            IWidgetContainer provider = ((MMDContainer)((Object)sender)).getProvider();
            if (provider instanceof TileEntity) {
                LoggingUtil.appendTileEntityInfo(log, (TileEntity)provider);
            }
        } else if (sender != null) {
            log.append("[sender: ");
            log.append(sender);
            log.append("] ");
        }
        if (!reason.isEmpty()) {
            log.append(reason);
            log.append(": ");
        }
        if (nbt != null) {
            log.append(nbt);
        } else {
            log.append("{NO TAG}");
        }
        MMDLib.logger.info(log.toString());
    }

    private static void appendTileEntityInfo(StringBuilder log, TileEntity sender) {
        log.append("[");
        World world = sender.func_145831_w();
        if (world != null) {
            log.append("dim: ");
            log.append(world.field_73011_w.getDimension());
            log.append(", ");
        } else {
            log.append("no dim info, ");
        }
        BlockPos pos = sender.func_174877_v();
        if (pos != null) {
            log.append(pos.toString());
        } else {
            log.append("no pos info");
        }
        log.append(", ");
        log.append(sender.getClass().getSimpleName());
        log.append("] ");
    }
}

