/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.util;

import com.google.common.collect.ImmutableList;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.recipe.RepairRecipeBase;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class CheeseMath {
    private CheeseMath() {
        throw new IllegalAccessError("Not a instantiable class");
    }

    private static IRecipe getRecipeFor(@Nonnull ItemStack outputItem) {
        IRecipe target = GameRegistry.findRegistry(IRecipe.class).getValuesCollection().stream().filter(rec -> OreDictionary.itemMatches((ItemStack)outputItem, (ItemStack)rec.func_77571_b(), (boolean)false) && !(rec instanceof RepairRecipeBase)).findFirst().orElse(null);
        return target;
    }

    private static NonNullList<Ingredient> getRecipeIngredients(@Nonnull ItemStack outputItem) {
        IRecipe target = CheeseMath.getRecipeFor(outputItem);
        return target == null ? NonNullList.func_191196_a() : target.func_192400_c();
    }

    private static ItemStack getItemStackFromList(List<ItemStack> isl, ItemStack target) {
        return isl.stream().filter(is -> is.func_77973_b().equals(target.func_77973_b()) && is.func_77960_j() == target.func_77960_j()).findFirst().orElse(ItemStack.field_190927_a);
    }

    private static int getOutputCount(@Nonnull ItemStack outputItem) {
        IRecipe t = CheeseMath.getRecipeFor(outputItem);
        if (t == null) {
            return 1;
        }
        return t.func_77571_b().func_190916_E();
    }

    protected static List<ItemStack> getIngredients(@Nonnull ItemStack outputItem) {
        ArrayList ingredients = new ArrayList();
        NonNullList<Ingredient> ing = CheeseMath.getRecipeIngredients(outputItem);
        if (!ing.isEmpty()) {
            ing.stream().map(i -> i.func_193365_a()).forEach(isa -> {
                for (ItemStack is : isa) {
                    ItemStack t = CheeseMath.getItemStackFromList(ingredients, is);
                    if (t.func_190926_b()) {
                        t = is.func_77946_l();
                        t.func_190920_e(1);
                        ingredients.add(t);
                        continue;
                    }
                    ((ItemStack)ingredients.get(ingredients.indexOf(t))).func_190920_e(t.func_190916_E() + 1);
                }
            });
        }
        return ImmutableList.copyOf(ingredients);
    }

    private static boolean itemStackMatches(ItemStack left, ItemStack right) {
        return left.func_77973_b().equals(right.func_77973_b()) && (left.func_77960_j() == Short.MAX_VALUE || right.func_77960_j() == Short.MAX_VALUE || left.func_77960_j() == right.func_77960_j());
    }

    private static boolean materialHasItem(MMDMaterial material, ItemStack match) {
        return material.getItems().stream().map(x -> CheeseMath.itemStackMatches(x, match)).distinct().collect(Collectors.toList()).contains(true);
    }

    private static int rawNuggetCount(@Nonnull MMDMaterial material, @Nonnull ItemStack outputItem) {
        return CheeseMath.getIngredients(outputItem).stream().mapToInt(itemStack -> {
            if (CheeseMath.itemStackMatches(itemStack, material.getItemStack(Names.INGOT))) {
                return itemStack.func_190916_E() * 9;
            }
            if (CheeseMath.itemStackMatches(itemStack, material.getItemStack(Names.NUGGET))) {
                return itemStack.func_190916_E();
            }
            if (CheeseMath.materialHasItem(material, itemStack)) {
                return CheeseMath.getNuggetCount(material, itemStack) * itemStack.func_190916_E();
            }
            return 0;
        }).sum();
    }

    public static int getIngotCount(@Nonnull MMDMaterial material, @Nonnull ItemStack outputItem) {
        if (outputItem.func_190926_b()) {
            return 0;
        }
        return CheeseMath.rawNuggetCount(material, outputItem) / 9 / CheeseMath.getOutputCount(outputItem);
    }

    public static int getNuggetCount(@Nonnull MMDMaterial material, @Nonnull ItemStack outputItem) {
        if (outputItem.func_190926_b()) {
            return 0;
        }
        return CheeseMath.rawNuggetCount(material, outputItem) / CheeseMath.getOutputCount(outputItem);
    }
}

