/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.registry.recipe;

import com.mcmoddev.lib.registry.recipe.ICrusherNBTRecipe;
import com.mcmoddev.lib.registry.recipe.ICrusherRecipe;
import com.mcmoddev.lib.registry.recipe.NBTCrusherRecipe;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class NBTOreDictRecipe
extends IForgeRegistryEntry.Impl<ICrusherRecipe>
implements ICrusherRecipe,
ICrusherNBTRecipe {
    private final NBTCrusherRecipe.OutputMunger outputCallback;
    private final InputMunger inputCallback;
    private final Predicate<ItemStack> validItemCallback;
    private final String inputItem;

    public NBTOreDictRecipe(String inputOreDict, NBTCrusherRecipe.OutputMunger nbtCallback, InputMunger inputCallback, Predicate<ItemStack> validItemCallback) {
        this.inputItem = inputOreDict;
        this.outputCallback = nbtCallback;
        this.inputCallback = inputCallback;
        this.validItemCallback = validItemCallback;
    }

    public NBTOreDictRecipe(String inputOreDict, NBTCrusherRecipe.OutputMunger nbtCallback, InputMunger inputCallback) {
        this(inputOreDict, nbtCallback, inputCallback, in -> OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)inputOreDict), (ItemStack[])new ItemStack[]{in}));
    }

    public NBTOreDictRecipe(String inputOreDict, NBTCrusherRecipe.OutputMunger nbtCallback, Predicate<ItemStack> validItemCallback) {
        this(inputOreDict, nbtCallback, in -> OreDictionary.getOres((String)in), validItemCallback);
    }

    public NBTOreDictRecipe(String inputOreDict, NBTCrusherRecipe.OutputMunger nbtCallback) {
        this(inputOreDict, nbtCallback, in -> OreDictionary.getOres((String)in), in -> OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)inputOreDict), (ItemStack[])new ItemStack[]{in}));
    }

    @Override
    public List<ItemStack> getInputs() {
        return this.inputCallback.run(this.inputItem);
    }

    @Override
    public ItemStack getOutput() {
        return this.getOutput(this.getInputs().get(0));
    }

    @Override
    public ItemStack getOutput(ItemStack input) {
        return this.isValidInput(input) ? this.outputCallback.run(input) : ItemStack.field_190927_a;
    }

    @Override
    public boolean isValidInput(ItemStack input) {
        return this.validItemCallback.test(input);
    }

    @Override
    public Collection<ItemStack> getValidInputs() {
        return Collections.unmodifiableList(this.getInputs());
    }

    public static interface InputMunger {
        public List<ItemStack> run(String var1);
    }
}

