/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.item;

import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.item.MMDItemHelper;
import com.mcmoddev.lib.material.IMMDObject;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.registry.CrusherRecipeRegistry;
import com.mcmoddev.lib.registry.recipe.ICrusherRecipe;
import com.mcmoddev.lib.util.Config;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemMMDCrackHammer
extends ItemTool
implements IMMDObject {
    private static final float ATTACK_SPEED = -3.0f;
    private final MMDMaterial material;
    private final Set<String> toolTypes;

    public ItemMMDCrackHammer(MMDMaterial material) {
        super(1.0f + Materials.getToolMaterialFor(material).func_78000_c(), -3.0f, Materials.getToolMaterialFor(material), new HashSet());
        this.material = material;
        this.field_77865_bY = 5.0f + 2.0f * this.material.getBaseAttackDamage();
        this.field_185065_c = -3.5f;
        this.func_77656_e((int)(0.75 * (double)this.material.getToolDurability()));
        this.field_77864_a = this.material.getToolEfficiency();
        this.toolTypes = new HashSet<String>();
        this.toolTypes.add(Names.CRACKHAMMER.toString());
        this.toolTypes.add(Names.PICKAXE.toString());
    }

    public float func_150893_a(ItemStack tool, IBlockState target) {
        if (this.isCrushableBlock(target) && this.func_150897_b(target)) {
            return Math.max(1.0f, 0.5f * this.material.getToolEfficiency());
        }
        return 1.0f;
    }

    public boolean func_179218_a(ItemStack tool, World world, IBlockState target, BlockPos coord, EntityLivingBase player) {
        IBlockState bs;
        ICrusherRecipe recipe;
        if (!world.field_72995_K && this.func_150897_b(target) && (recipe = this.getCrusherRecipe(bs = world.func_180495_p(coord))) != null) {
            ItemStack output = recipe.getOutput().func_77946_l();
            world.func_175698_g(coord);
            if (output != null) {
                int num = output.func_190916_E();
                output.func_190920_e(1);
                for (int i = 0; i < num; ++i) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)coord.func_177958_n() + 0.5, (double)coord.func_177956_o() + 0.5, (double)coord.func_177952_p() + 0.5, output.func_77946_l()));
                }
            }
        }
        return super.func_179218_a(tool, world, target, coord, player);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World w, BlockPos coord, EnumHand hand, EnumFacing facing, float partialX, float partialY, float partialZ) {
        ItemStack item = player.func_184614_ca();
        if (facing != EnumFacing.UP) {
            return EnumActionResult.PASS;
        }
        AxisAlignedBB boundingBox = new AxisAlignedBB((double)coord.func_177958_n(), (double)(coord.func_177956_o() + 1), (double)coord.func_177952_p(), (double)(coord.func_177958_n() + 1), (double)(coord.func_177956_o() + 2), (double)(coord.func_177952_p() + 1));
        List entities = w.func_72872_a(EntityItem.class, boundingBox).stream().filter(elem -> elem.func_92059_d() != null).filter(elem -> CrusherRecipeRegistry.getRecipeForInputItem(elem.func_92059_d()) != null).collect(Collectors.toList());
        if (!entities.isEmpty()) {
            ItemStack targetItem = ((EntityItem)entities.get(0)).func_92059_d();
            ICrusherRecipe recipe = CrusherRecipeRegistry.getRecipeForInputItem(targetItem);
            if (this.hardnessCheck(targetItem)) {
                return EnumActionResult.PASS;
            }
            this.maybeDoCrack(recipe, targetItem, item, (EntityItem)entities.get(0), player, w);
            w.func_184133_a(player, coord, SoundEvents.field_187581_bW, SoundCategory.BLOCKS, 0.5f, 0.5f + field_77697_d.nextFloat() * 0.3f);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private void maybeDoCrack(ICrusherRecipe recipe, ItemStack targetItem, ItemStack item, EntityItem target, EntityPlayer player, World w) {
        if (!w.field_72995_K) {
            ItemStack output = recipe.getOutput().func_77946_l();
            int crackedCount = this.doDamageCheck(targetItem, item);
            double x = target.field_70165_t;
            double y = target.field_70163_u;
            double z = target.field_70161_v;
            this.doCrack(targetItem, crackedCount);
            this.maybeRemoveEntity(targetItem, target, w);
            this.spawnResults(output, x, y, z, crackedCount, w);
            item.func_77972_a(crackedCount, (EntityLivingBase)player);
            if (item.func_77958_k() == item.func_77952_i()) {
                item.func_77972_a(1, (EntityLivingBase)player);
            }
        }
    }

    private boolean hardnessCheck(ItemStack targetItemStack) {
        Block b;
        Item targetItem = targetItemStack.func_77973_b();
        return Config.Options.enforceHardness() && targetItem instanceof ItemBlock && !this.func_150897_b((b = ((ItemBlock)targetItem).func_179223_d()).func_176203_a(targetItemStack.func_77960_j()));
    }

    private void spawnResults(ItemStack output, double x, double y, double z, int crackedCount, World w) {
        for (int i = 0; i < crackedCount; ++i) {
            w.func_72838_d((Entity)new EntityItem(w, x, y, z, output.func_77946_l()));
        }
    }

    private void maybeRemoveEntity(ItemStack targetItem, EntityItem target, World w) {
        if (targetItem.func_190916_E() <= 0) {
            w.func_72900_e((Entity)target);
        }
    }

    private void doCrack(ItemStack targetItem, int crackedCount) {
        if (Config.Options.crackHammerFullStack()) {
            targetItem.func_190918_g(crackedCount);
        } else {
            targetItem.func_190918_g(1);
        }
    }

    private int doDamageCheck(ItemStack targetItem, ItemStack item) {
        if (Config.Options.crackHammerFullStack()) {
            int remainingDamage = item.func_77958_k() - item.func_77952_i();
            return Math.min(targetItem.func_190916_E(), Math.min(targetItem.func_77976_d(), remainingDamage));
        }
        return 1;
    }

    protected boolean isCrushableBlock(IBlockState block) {
        return this.getCrusherRecipe(block) != null;
    }

    protected boolean isCrushableBlock(Block block) {
        return this.getCrusherRecipe(block) != null;
    }

    protected ICrusherRecipe getCrusherRecipe(Block block) {
        return this.getCrusherRecipe(block.func_176223_P());
    }

    protected ICrusherRecipe getCrusherRecipe(@Nullable IBlockState blockState) {
        if (blockState == null) {
            return null;
        }
        Block block = blockState.func_177230_c();
        if (Item.func_150898_a((Block)block) == null) {
            return null;
        }
        return CrusherRecipeRegistry.getRecipeForInputItem(new ItemStack(block, 1, block.func_176201_c(blockState)));
    }

    public int func_77619_b() {
        return this.field_77862_b.func_77995_e();
    }

    public String func_77861_e() {
        return this.field_77862_b.toString();
    }

    public boolean func_82789_a(ItemStack intputItem, ItemStack repairMaterial) {
        return MMDItemHelper.isToolRepairable(repairMaterial, this.material.getCapitalizedName());
    }

    @Deprecated
    public int getHarvestLevel(ItemStack stack, @Nullable String typeRequested, @Nullable EntityPlayer player, IBlockState blockState) {
        if (typeRequested != null && this.toolTypes.contains(typeRequested)) {
            if (Config.Options.strongHammers()) {
                return this.material.getToolHarvestLevel();
            }
            return this.material.getToolHarvestLevel() - 1;
        }
        return -1;
    }

    public Set<String> getToolClasses(ItemStack item) {
        return this.toolTypes;
    }

    public boolean func_77644_a(ItemStack item, EntityLivingBase target, EntityLivingBase attacker) {
        super.func_77644_a(item, target, attacker);
        if (this.getMMDMaterial().hasEffect(item, target)) {
            this.getMMDMaterial().applyEffect(item, target);
        }
        return true;
    }

    public void func_77622_d(ItemStack item, World world, EntityPlayer crafter) {
        super.func_77622_d(item, world, crafter);
        if (this.getMMDMaterial().hasEffect(item, crafter)) {
            this.getMMDMaterial().applyEffect(item, crafter);
        }
    }

    public void func_77663_a(ItemStack item, World world, Entity player, int inventoryIndex, boolean isHeld) {
        MMDItemHelper.doRegeneration(item, world, isHeld, this.material.regenerates());
    }

    public boolean func_150897_b(IBlockState targetBS) {
        Block target = targetBS.func_177230_c();
        EntityPlayer player = null;
        String toolType = target.getHarvestTool(target.func_176223_P());
        if (this.toolTypes.contains(toolType) || target.func_149688_o(targetBS) == Material.field_151576_e) {
            return this.getHarvestLevel(ItemStack.field_190927_a, Names.PICKAXE.toString(), player, targetBS) >= target.getHarvestLevel(target.func_176223_P());
        }
        if (Names.SHOVEL.toString().equals(toolType) && target.getHarvestLevel(target.func_176223_P()) <= 0) {
            return true;
        }
        return target.getHarvestLevel(target.func_176223_P()) == -1;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        List<String> tt = this.getMMDMaterial().getTooltipFor(Names.CRACKHAMMER);
        if (!tt.isEmpty()) {
            tooltip.addAll(tt);
        }
    }

    @Override
    public MMDMaterial getMMDMaterial() {
        return this.material;
    }
}

