/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.item;

import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.item.MMDItemHelper;
import com.mcmoddev.lib.material.IMMDObject;
import com.mcmoddev.lib.material.MMDMaterial;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMMDArmor
extends ItemArmor
implements IMMDObject {
    private final String customTexture;
    private final MMDMaterial mmdMaterial;
    private static final int UPDATE_INTERVAL = 11;
    private static final Map<EntityPlayer, AtomicLong> playerUpdateTimestampMap = new HashMap<EntityPlayer, AtomicLong>();
    private static final Map<EntityPlayer, AtomicInteger> playerUpdateCountMap = new HashMap<EntityPlayer, AtomicInteger>();

    protected ItemMMDArmor(@Nonnull MMDMaterial material, @Nonnull ItemArmor.ArmorMaterial armorMat, int renderIndex, EntityEquipmentSlot slot) {
        super(armorMat, renderIndex, slot);
        this.mmdMaterial = material;
        this.customTexture = Loader.instance().activeModContainer().getModId() + ":textures/models/armor/" + material.getName() + "_layer_" + (slot == EntityEquipmentSlot.LEGS ? 2 : 1) + ".png";
    }

    public void onArmorTick(World w, EntityPlayer player, ItemStack armor) {
        if (!playerUpdateTimestampMap.containsKey(player)) {
            playerUpdateTimestampMap.put(player, new AtomicLong(0L));
            playerUpdateCountMap.put(player, new AtomicInteger(0));
            return;
        }
        if (!w.field_72995_K && w.func_82737_E() > playerUpdateTimestampMap.get(player).get()) {
            playerUpdateTimestampMap.get(player).set(w.func_82737_E() + 11L);
            if (this.mmdMaterial.hasEffect(armor, player)) {
                this.mmdMaterial.applyEffect(armor, player);
            }
        }
    }

    public static ItemMMDArmor createArmor(@Nonnull MMDMaterial material, Names name) {
        EntityEquipmentSlot slot = null;
        switch (name) {
            case HELMET: {
                slot = EntityEquipmentSlot.HEAD;
                break;
            }
            case CHESTPLATE: {
                slot = EntityEquipmentSlot.CHEST;
                break;
            }
            case LEGGINGS: {
                slot = EntityEquipmentSlot.LEGS;
                break;
            }
            case BOOTS: {
                slot = EntityEquipmentSlot.FEET;
                break;
            }
            default: {
                return null;
            }
        }
        return ItemMMDArmor.createArmorBase(material, slot);
    }

    protected static ItemMMDArmor createArmorBase(@Nonnull MMDMaterial material, EntityEquipmentSlot slot) {
        ItemArmor.ArmorMaterial amaterial = Materials.getArmorMaterialFor(material);
        if (amaterial == null) {
            MMDLib.logger.error("Failed to load armor material enum for " + (Object)((Object)material));
            return null;
        }
        return new ItemMMDArmor(material, amaterial, amaterial.ordinal(), slot);
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity e, EntityEquipmentSlot slot, String layer) {
        return this.customTexture;
    }

    private Names getNameForPiece(ItemStack itemStack) {
        if (itemStack.func_77973_b() == this.mmdMaterial.getItem(Names.HELMET)) {
            return Names.HELMET;
        }
        if (itemStack.func_77973_b() == this.mmdMaterial.getItem(Names.CHESTPLATE)) {
            return Names.CHESTPLATE;
        }
        if (itemStack.func_77973_b() == this.mmdMaterial.getItem(Names.LEGGINGS)) {
            return Names.LEGGINGS;
        }
        if (itemStack.func_77973_b() == this.mmdMaterial.getItem(Names.BOOTS)) {
            return Names.BOOTS;
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Names partName = this.getNameForPiece(stack);
        if (partName == null) {
            return;
        }
        List<String> tt = this.mmdMaterial.getTooltipFor(this.getNameForPiece(stack));
        if (tt.isEmpty()) {
            return;
        }
        tooltip.addAll(tt);
    }

    public void extraEffectsOnCrafting(ItemStack item, World world, EntityPlayer crafter) {
    }

    public boolean func_82789_a(ItemStack srcItemStack, ItemStack repairMaterial) {
        return MMDItemHelper.isToolRepairable(repairMaterial, this.mmdMaterial.getCapitalizedName());
    }

    public void func_77622_d(ItemStack item, World world, EntityPlayer crafter) {
        super.func_77622_d(item, world, crafter);
        this.extraEffectsOnCrafting(item, world, crafter);
    }

    @Override
    public MMDMaterial getMMDMaterial() {
        return this.mmdMaterial;
    }
}

