/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.inventory;

import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.inventory.IFilteredFluidTank;
import com.mcmoddev.lib.inventory.IFluidTankModifiable;
import com.mcmoddev.lib.inventory.IResponsiveFluidTank;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class ResponsiveFluidTankWrapper
implements IFluidTankModifiable,
IResponsiveFluidTank,
IFluidTank,
IFilteredFluidTank {
    private final List<Consumer<IResponsiveFluidTank>> responsiveTargets = new ArrayList<Consumer<IResponsiveFluidTank>>();
    private final IFluidTank tank;
    private final IFluidTankModifiable modifiableTank;
    private final IFilteredFluidTank filteredTank;

    public ResponsiveFluidTankWrapper(IFluidTank tank, Consumer<ResponsiveFluidTankWrapper> responsiveTarget) {
        this.tank = tank;
        this.filteredTank = this.tank instanceof IFilteredFluidTank ? (IFilteredFluidTank)this.tank : null;
        this.modifiableTank = this.tank instanceof IFluidTankModifiable ? (IFluidTankModifiable)this.tank : null;
        this.addResponsiveTarget(responsiveTarget);
    }

    @Override
    public boolean canFill(FluidStack fluid) {
        return this.filteredTank == null || this.filteredTank.canFill(fluid);
    }

    @Override
    public boolean canDrain(FluidStack fluid) {
        return this.filteredTank == null || this.filteredTank.canDrain(fluid);
    }

    @Override
    public void setFluid(@Nullable FluidStack fluid) {
        if (this.modifiableTank != null) {
            this.modifiableTank.setFluid(fluid);
            this.onChanged();
        } else {
            MMDLib.logger.error("Someone or something tried to set the fluid in a non-modifiable tank!");
        }
    }

    @Override
    public <T extends IResponsiveFluidTank> void addResponsiveTarget(Consumer<T> consumer) {
        this.responsiveTargets.add(consumer);
    }

    @Nullable
    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public FluidTankInfo getInfo() {
        return this.tank.getInfo();
    }

    public int fill(FluidStack resource, boolean doFill) {
        int filled = this.tank.fill(resource, doFill);
        if (doFill && filled > 0) {
            this.onChanged();
        }
        return filled;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack drained = this.tank.drain(maxDrain, doDrain);
        if (doDrain && drained != null && drained.amount > 0) {
            this.onChanged();
        }
        return drained;
    }

    protected void onChanged() {
        this.responsiveTargets.forEach(t -> t.accept(this));
    }
}

