/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.inventory;

import com.mcmoddev.lib.inventory.IFilteredFluidTank;
import com.mcmoddev.lib.inventory.IFluidTankModifiable;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class FilteredFluidTank
implements IFluidTank,
IFluidTankModifiable,
IFilteredFluidTank {
    private final IFluidTankModifiable internal;
    @Nullable
    private final Predicate<FluidStack> fillFilter;
    @Nullable
    private final Predicate<FluidStack> drainFilter;

    public FilteredFluidTank(IFluidTankModifiable innerTank, @Nullable Predicate<FluidStack> fillFilter, @Nullable Predicate<FluidStack> drainFilter) {
        FluidStack existing;
        this.internal = innerTank;
        this.drainFilter = drainFilter;
        if (fillFilter == null && (existing = this.internal.getFluid()) != null && existing.getFluid() != null) {
            fillFilter = stack -> stack.isFluidEqual(existing);
        }
        this.fillFilter = fillFilter;
    }

    @Override
    public boolean canFill(FluidStack fluid) {
        return this.fillFilter == null || this.fillFilter.test(fluid);
    }

    @Override
    public boolean canDrain(FluidStack fluid) {
        return this.drainFilter == null || this.drainFilter.test(fluid);
    }

    @Nullable
    public FluidStack getFluid() {
        return this.internal.getFluid();
    }

    public int getFluidAmount() {
        return this.internal.getFluidAmount();
    }

    public int getCapacity() {
        return this.internal.getCapacity();
    }

    public FluidTankInfo getInfo() {
        return this.internal.getInfo();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (!this.canFill(resource)) {
            return 0;
        }
        return this.internal.fill(resource, doFill);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack simulated = this.internal.drain(maxDrain, false);
        if (simulated != null && simulated.amount > 0) {
            if (!this.canDrain(simulated)) {
                return null;
            }
            if (doDrain) {
                return this.internal.drain(maxDrain, true);
            }
        }
        return simulated;
    }

    @Override
    public void setFluid(@Nullable FluidStack fluid) {
        if (fluid != null && !this.canFill(fluid)) {
            throw new RuntimeException("Cannot set tank content to an unacceptable fluid.");
        }
        this.internal.setFluid(fluid);
    }
}

