/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class CombinedFluidHandler
implements IFluidHandler {
    private final List<IFluidHandler> handlers = new ArrayList<IFluidHandler>();

    public CombinedFluidHandler(IFluidHandler ... handlers) {
        this.handlers.addAll(Arrays.asList(handlers));
    }

    public void addFluidHandler(IFluidHandler handler) {
        this.handlers.add(handler);
    }

    public IFluidTankProperties[] getTankProperties() {
        ArrayList<IFluidTankProperties> tanks = new ArrayList<IFluidTankProperties>();
        for (IFluidHandler handler : this.handlers) {
            tanks.addAll(Arrays.asList(handler.getTankProperties()));
        }
        return tanks.toArray(new IFluidTankProperties[0]);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || resource.amount == 0) {
            return 0;
        }
        int filled = 0;
        FluidStack remaining = resource.copy();
        for (IFluidHandler handler : this.handlers) {
            int current = handler.fill(remaining, doFill);
            if (current > 0) {
                filled += current;
                remaining.amount = Math.max(0, remaining.amount - current);
            }
            if (remaining.amount != 0) continue;
            break;
        }
        return filled;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || resource.amount == 0) {
            return null;
        }
        int drained = 0;
        FluidStack toDrain = resource.copy();
        for (IFluidHandler handler : this.handlers) {
            FluidStack current = handler.drain(toDrain, doDrain);
            if (current != null && current.amount > 0) {
                drained += current.amount;
                toDrain.amount = Math.max(0, toDrain.amount - current.amount);
            }
            if (toDrain.amount != 0) continue;
            break;
        }
        toDrain.amount = drained;
        return toDrain.amount == 0 ? null : toDrain;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack toDrain = Arrays.stream(this.getTankProperties()).filter(t -> t.canDrain() && t.getContents() != null && t.getContents().amount > 0).map(IFluidTankProperties::getContents).findFirst().orElse(null);
        if (toDrain == null) {
            return null;
        }
        toDrain.amount = maxDrain;
        return this.drain(toDrain, doDrain);
    }
}

