/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.integration.plugins.tinkers;

import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.integration.plugins.tinkers.traits.MMDTraits;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.tools.TinkerTraits;

public class TraitRegistry {
    private static final Map<String, ITrait> registeredTraits = new HashMap<String, ITrait>();

    private TraitRegistry() {
        throw new IllegalAccessError("Not an instantiable class");
    }

    public static void addTrait(@Nonnull String name, @Nonnull ITrait trait) {
        registeredTraits.put(name, trait);
    }

    public static boolean hasTrait(@Nonnull String name) {
        return registeredTraits.keySet().contains(name);
    }

    public static ITrait getTrait(@Nonnull String name) {
        if (registeredTraits.isEmpty()) {
            TraitRegistry.initTraits();
            TraitRegistry.initTiCTraits();
        }
        if (registeredTraits.containsKey(name)) {
            return registeredTraits.get(name);
        }
        return TinkerRegistry.getTrait((String)name);
    }

    public static ITrait get(@Nonnull String name) {
        return TraitRegistry.getTrait(name);
    }

    public static void initTiCTraits() {
        registeredTraits.put("alien", (ITrait)TinkerTraits.alien);
        registeredTraits.put("aquadynamic", (ITrait)TinkerTraits.aquadynamic);
        registeredTraits.put("aridiculous", (ITrait)TinkerTraits.aridiculous);
        registeredTraits.put("autosmelt", (ITrait)TinkerTraits.autosmelt);
        registeredTraits.put("baconlicious", (ITrait)TinkerTraits.baconlicious);
        registeredTraits.put("cheap", (ITrait)TinkerTraits.cheap);
        registeredTraits.put("cheapskate", (ITrait)TinkerTraits.cheapskate);
        registeredTraits.put("coldblooded", (ITrait)TinkerTraits.coldblooded);
        registeredTraits.put("crude", (ITrait)TinkerTraits.crude);
        registeredTraits.put("crude2", (ITrait)TinkerTraits.crude2);
        registeredTraits.put("crumbling", (ITrait)TinkerTraits.crumbling);
        registeredTraits.put("dense", (ITrait)TinkerTraits.dense);
        registeredTraits.put("depthdigger", (ITrait)TinkerTraits.depthdigger);
        registeredTraits.put("duritos", (ITrait)TinkerTraits.duritos);
        registeredTraits.put("ecological", (ITrait)TinkerTraits.ecological);
        registeredTraits.put("enderference", (ITrait)TinkerTraits.enderference);
        registeredTraits.put("established", (ITrait)TinkerTraits.established);
        registeredTraits.put("flammable", (ITrait)TinkerTraits.flammable);
        registeredTraits.put("fractured", (ITrait)TinkerTraits.fractured);
        registeredTraits.put("hellish", (ITrait)TinkerTraits.hellish);
        registeredTraits.put("holy", (ITrait)TinkerTraits.holy);
        registeredTraits.put("insatiable", (ITrait)TinkerTraits.insatiable);
        registeredTraits.put("jagged", (ITrait)TinkerTraits.jagged);
        registeredTraits.put("lightweight", (ITrait)TinkerTraits.lightweight);
        registeredTraits.put("magnetic", (ITrait)TinkerTraits.magnetic);
        registeredTraits.put("magnetic2", (ITrait)TinkerTraits.magnetic2);
        registeredTraits.put("momentum", (ITrait)TinkerTraits.momentum);
        registeredTraits.put("petramor", (ITrait)TinkerTraits.petramor);
        registeredTraits.put("poisonous", (ITrait)TinkerTraits.poisonous);
        registeredTraits.put("prickly", (ITrait)TinkerTraits.prickly);
        registeredTraits.put("sharp", (ITrait)TinkerTraits.sharp);
        registeredTraits.put("shocking", (ITrait)TinkerTraits.shocking);
        registeredTraits.put("slimeyGreen", (ITrait)TinkerTraits.slimeyGreen);
        registeredTraits.put("slimeyBlue", (ITrait)TinkerTraits.slimeyBlue);
        registeredTraits.put("spiky", (ITrait)TinkerTraits.spiky);
        registeredTraits.put("splintering", (ITrait)TinkerTraits.splintering);
        registeredTraits.put("splinters", (ITrait)TinkerTraits.splinters);
        registeredTraits.put("squeaky", (ITrait)TinkerTraits.squeaky);
        registeredTraits.put("superheat", (ITrait)TinkerTraits.superheat);
        registeredTraits.put("stiff", (ITrait)TinkerTraits.stiff);
        registeredTraits.put("stonebound", (ITrait)TinkerTraits.stonebound);
        registeredTraits.put("tasty", (ITrait)TinkerTraits.tasty);
        registeredTraits.put("unnatural", (ITrait)TinkerTraits.unnatural);
        registeredTraits.put("writable", (ITrait)TinkerTraits.writable);
        registeredTraits.put("writable2", (ITrait)TinkerTraits.writable2);
        registeredTraits.put("breakable", (ITrait)TinkerTraits.breakable);
        registeredTraits.put("endspeed", (ITrait)TinkerTraits.endspeed);
        registeredTraits.put("freezing", (ITrait)TinkerTraits.freezing);
        registeredTraits.put("hovering", (ITrait)TinkerTraits.hovering);
        registeredTraits.put("splitting", (ITrait)TinkerTraits.splitting);
    }

    public static void initTraits() {
        registeredTraits.put("soft", (ITrait)MMDTraits.soft);
        registeredTraits.put("sparkly", (ITrait)MMDTraits.sparkly);
        registeredTraits.put("heavy", (ITrait)MMDTraits.heavy);
        registeredTraits.put("brittle", (ITrait)MMDTraits.brittle);
        registeredTraits.put("toxic", (ITrait)MMDTraits.toxic);
        registeredTraits.put("radioactive", (ITrait)MMDTraits.radioactive);
        registeredTraits.put("reactive", (ITrait)MMDTraits.reactive);
    }

    public static void dumpRegistry() {
        for (Map.Entry<String, ITrait> e : registeredTraits.entrySet()) {
            String t = String.format("BaseMetals-TCon> Trait: %s - class %s", e.getKey(), e.getValue().getClass().getName());
            MMDLib.logger.info(t);
        }
    }

    public static void registerTraits() {
    }
}

