/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.integration.plugins.tinkers;

import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.integration.plugins.tinkers.TCMaterial;
import com.mcmoddev.lib.material.MMDMaterial;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.ArrowShaftMaterialStats;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.FletchingMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;
import slimeknights.tconstruct.library.traits.ITrait;

public class TinkersConstructRegistry {
    public static final TinkersConstructRegistry instance = new TinkersConstructRegistry();
    private static final Map<String, Map<String, TCMaterial>> registry = new HashMap<String, Map<String, TCMaterial>>();
    private static final Map<String, List<MaterialIntegration>> integrations = new HashMap<String, List<MaterialIntegration>>();
    private static final Map<String, Map<String, AlloyRecipe>> alloys = new HashMap<String, Map<String, AlloyRecipe>>();
    private static final Map<String, Map<Item, FluidStack>> meltings = new HashMap<String, Map<Item, FluidStack>>();

    private TinkersConstructRegistry() {
    }

    public TCMaterial newMaterial(@Nonnull String name, @Nonnull int color) {
        TCMaterial temp;
        String curMod = Loader.instance().activeModContainer().getModId();
        Map work = registry.getOrDefault(curMod, new HashMap());
        if (work.isEmpty() || !work.containsKey(name)) {
            temp = TCMaterial.get(name, color);
            work.put(name, temp);
            registry.put(curMod, work);
        } else {
            temp = (TCMaterial)work.get(name);
        }
        return temp;
    }

    public TCMaterial newMaterial(@Nonnull MMDMaterial mat) {
        String curMod = Loader.instance().activeModContainer().getModId();
        Map work = registry.getOrDefault(curMod, new HashMap());
        if (work.isEmpty() || !work.containsKey(mat.getName())) {
            work.put(mat.getName(), TCMaterial.get(mat));
            registry.put(curMod, work);
        }
        return (TCMaterial)work.get(mat.getName());
    }

    public TCMaterial getMaterial(@Nonnull String name) {
        for (Map.Entry<String, Map<String, TCMaterial>> ent : registry.entrySet()) {
            if (!ent.getValue().containsKey(name)) continue;
            return ent.getValue().get(name);
        }
        return this.newMaterial(name, -1);
    }

    public void addMaterialStats() {
        String curMod = Loader.instance().activeModContainer().getModId();
        for (Map.Entry<String, TCMaterial> entry : registry.get(curMod).entrySet()) {
            entry.getValue().settle();
            HeadMaterialStats headStats = entry.getValue().getHeadStats();
            HandleMaterialStats handleStats = entry.getValue().getHandleStats();
            ExtraMaterialStats extraStats = entry.getValue().getExtraStats();
            BowMaterialStats bowStats = entry.getValue().getBowStats();
            ArrowShaftMaterialStats arrowStats = entry.getValue().getArrowStats();
            FletchingMaterialStats fletchingStats = entry.getValue().getFletchingStats();
            if (TinkerRegistry.getMaterial((String)entry.getKey()) != entry.getValue().getMaterial()) continue;
            Material work = entry.getValue().getMaterial();
            TinkerRegistry.addMaterialStats((Material)work, (IMaterialStats)headStats, (IMaterialStats[])new IMaterialStats[]{handleStats, extraStats});
            TinkerRegistry.addMaterialStats((Material)work, (IMaterialStats)bowStats);
            TinkerRegistry.addMaterialStats((Material)work, (IMaterialStats)arrowStats);
            TinkerRegistry.addMaterialStats((Material)work, (IMaterialStats)fletchingStats);
        }
    }

    public void registerAlloy(@Nonnull String name, @Nonnull FluidStack result, FluidStack ... input) {
        String curMod = Loader.instance().activeModContainer().getModId();
        Map curRecipes = alloys.getOrDefault(curMod, new HashMap());
        if (curRecipes.containsKey(name)) {
            return;
        }
        curRecipes.put(name, new AlloyRecipe(result, input));
        alloys.put(curMod, curRecipes);
    }

    public void registerMelting(@Nonnull Item item, @Nonnull FluidStack result) {
        String curMod = Loader.instance().activeModContainer().getModId();
        Map modMelts = meltings.getOrDefault(curMod, new HashMap());
        if (modMelts.containsKey(item)) {
            return;
        }
        modMelts.put(item, result);
        meltings.put(curMod, modMelts);
    }

    public void setRepresentativeItem() {
        String curMod = Loader.instance().activeModContainer().getModId();
        for (Map.Entry<String, TCMaterial> entry : registry.get(curMod).entrySet()) {
            entry.getValue().setRepresentativeItem(Names.INGOT.toString());
        }
    }

    public void setupIntegrations() {
        String curMod = Loader.instance().activeModContainer().getModId();
        MMDLib.logger.debug("setupIntegrations() for mod %s (%d integrations)", (Object)curMod, (Object)registry.get(curMod).size());
        for (Map.Entry<String, TCMaterial> entry : registry.get(curMod).entrySet()) {
            MMDLib.logger.debug("processing material %s from mod %s", (Object)entry.getKey(), (Object)curMod);
            TCMaterial material = entry.getValue();
            material.settle();
            material.setFluid(material.getMMDMaterial().getFluid());
            if (material.getCraftable()) {
                material.getMaterial().setCraftable(true);
            } else {
                material.getMaterial().setCastable(true);
            }
            MaterialIntegration integration = new MaterialIntegration(material.getMaterial(), material.getFluid(), material.getMMDMaterial().getCapitalizedName());
            if (material.getRepresentativeItemName() != null) {
                integration.setRepresentativeItem(material.getRepresentativeItemName());
            }
            if (material.toolForge()) {
                integration.toolforge();
            }
            List cmi = integrations.getOrDefault(curMod, new ArrayList());
            cmi.add(integration);
            integrations.put(curMod, cmi);
            TinkerRegistry.integrate((MaterialIntegration)integration);
            integration.preInit();
        }
    }

    private void addTraits(TCMaterial mat) {
        if (!mat.getTraits().isEmpty()) {
            for (Map.Entry<String, List<ITrait>> ent : mat.getTraits().entrySet()) {
                String traitLoc = ent.getKey();
                for (ITrait trait : ent.getValue()) {
                    if (traitLoc.equals("general")) {
                        mat.getMaterial().addTrait(trait);
                        continue;
                    }
                    mat.getMaterial().addTrait(trait, traitLoc);
                }
            }
        }
    }

    public void integrationsInit(@Nonnull String forMod) {
        String curMod = forMod;
        for (Map.Entry<String, TCMaterial> entry : registry.get(curMod).entrySet()) {
            TCMaterial work = entry.getValue();
            MMDMaterial curMMDMat = work.getMMDMaterial();
            Material curMat = work.getMaterial();
            Item rI = curMMDMat.getItem(Names.INGOT);
            curMat.addItem(rI, 1, 144);
            curMat.setRepresentativeItem(rI);
            curMat.addCommonItems(curMMDMat.getCapitalizedName());
            this.addTraits(work);
        }
    }

    public void registerMeltings(@Nonnull String forMod) {
        String curMod = forMod;
        Map myMelts = meltings.getOrDefault(curMod, Collections.emptyMap());
        if (myMelts.isEmpty()) {
            return;
        }
        for (Map.Entry ent : myMelts.entrySet()) {
            Item item = (Item)ent.getKey();
            FluidStack fluidStack = (FluidStack)ent.getValue();
            Fluid fluid = fluidStack.getFluid();
            int amount = fluidStack.amount;
            TinkerRegistry.registerMelting((Item)item, (Fluid)fluid, (int)amount);
        }
    }

    public void registerAlloys(@Nonnull String forMod) {
        String curMod = forMod;
        if (alloys.containsKey(curMod)) {
            Map<String, AlloyRecipe> curRecipes = alloys.get(curMod);
            for (Map.Entry<String, AlloyRecipe> ent : curRecipes.entrySet()) {
                TinkerRegistry.registerAlloy((AlloyRecipe)ent.getValue());
            }
        }
    }

    public void resolveTraits(@Nonnull String forMod) {
        MMDLib.logger.debug("Resolving traits for materials added by mod %s", (Object)forMod);
        for (Map.Entry<String, TCMaterial> entry : registry.get(forMod).entrySet()) {
            MMDLib.logger.debug("Resolving traits for material %s (%s)", (Object)entry.getKey(), (Object)entry.getValue());
            entry.getValue().resolveTraits();
        }
    }

    public void setMaterialsVisible(@Nonnull String forMod) {
        String curMod = forMod;
        for (Map.Entry<String, TCMaterial> entry : registry.get(curMod).entrySet()) {
            if (!entry.getValue().getMaterial().isHidden()) continue;
            MMDLib.logger.debug("Setting material %s to visible", (Object)entry.getValue().getMMDMaterial().getCapitalizedName());
            entry.getValue().getMaterial().setVisible();
        }
    }
}

