/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.integration.plugins.tinkers;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.tools.TinkerTraits;

public class TinkerTraitRegistry {
    private static final Map<String, ITrait> traitsRegistry = new ConcurrentHashMap<String, ITrait>(256);

    public void register(String traitName, ITrait trait) {
        traitsRegistry.put(traitName, trait);
    }

    @Nullable
    public ITrait get(String traitName) {
        ITrait pos = TinkerRegistry.getTrait((String)traitName);
        if (traitsRegistry.containsKey(traitName)) {
            return traitsRegistry.get(traitName);
        }
        if (pos != null) {
            return pos;
        }
        try {
            Field f = TinkerTraits.class.getDeclaredField(traitName);
            if (f != null) {
                return (ITrait)f.get(null);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return null;
        }
        return null;
    }

    public List<ITrait> getTraits() {
        return Collections.unmodifiableList(new ArrayList<ITrait>(traitsRegistry.values()));
    }
}

