/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.integration.plugins.thaumcraft;

import com.mcmoddev.lib.data.NameToken;
import com.mcmoddev.lib.data.NameTokens;
import com.mcmoddev.lib.integration.plugins.thaumcraft.IAspectCalculation;
import com.mcmoddev.lib.integration.plugins.thaumcraft.IAspectGetter;
import com.mcmoddev.lib.material.MMDMaterial;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import thaumcraft.api.aspects.Aspect;

public class BaseAspectGetter
implements IAspectGetter {
    private final MMDMaterial wrapped;
    private final IAspectCalculation genericCalc = multiplier -> this.doGenericCalc(multiplier);
    private final IAspectCalculation genericMagicCalc = multiplier -> this.doGenericMagicCalc(multiplier);
    private final IAspectCalculation fixedValue = multiplier -> 5;

    public BaseAspectGetter(MMDMaterial baseClass) {
        this.wrapped = baseClass;
    }

    @Override
    public IAspectCalculation getCalcFor(Aspect aspect) {
        if (aspect.equals(Aspect.MAGIC)) {
            return this.genericMagicCalc;
        }
        return this.genericCalc;
    }

    @Override
    public List<Pair<Aspect, IAspectCalculation>> getAspectForPart(NameToken part) {
        ArrayList rv;
        block20: {
            block19: {
                rv = new ArrayList();
                if (!part.equals(MATERIAL_WIDE)) break block19;
                switch (this.wrapped.getType()) {
                    case METAL: {
                        rv.add(Pair.of((Object)Aspect.METAL, (Object)this.fixedValue));
                        break block20;
                    }
                    case CRYSTAL: {
                        rv.add(Pair.of((Object)Aspect.CRYSTAL, (Object)this.fixedValue));
                        break block20;
                    }
                    case GEM: {
                        rv.add(Pair.of((Object)Aspect.CRYSTAL, (Object)this.fixedValue));
                        rv.add(Pair.of((Object)Aspect.DESIRE, (Object)this.fixedValue));
                        break block20;
                    }
                    case MINERAL: {
                        rv.add(Pair.of((Object)Aspect.ALCHEMY, (Object)this.fixedValue));
                        break block20;
                    }
                    case ROCK: {
                        rv.add(Pair.of((Object)Aspect.ORDER, (Object)this.fixedValue));
                        break block20;
                    }
                    case WOOD: {
                        rv.add(Pair.of((Object)Aspect.PLANT, (Object)this.fixedValue));
                        break block20;
                    }
                    default: {
                        return Collections.emptyList();
                    }
                }
            }
            if (part.equals(NameTokens.ORE) && (this.wrapped.getDefaultDimension() == 0 || this.wrapped.getDefaultDimension() == Integer.MIN_VALUE)) {
                rv.add(Pair.of((Object)Aspect.EARTH, (Object)this.fixedValue));
            } else if (part.equals(NameTokens.NETHERORE) || this.wrapped.getDefaultDimension() == -1) {
                rv.add(Pair.of((Object)Aspect.FIRE, (Object)this.fixedValue));
            } else if (part.equals(NameTokens.ENDORE) || this.wrapped.getDefaultDimension() == 1) {
                rv.add(Pair.of((Object)Aspect.DARKNESS, (Object)this.fixedValue));
            } else if (part.equals(NameTokens.BLEND) || part.equals(NameTokens.SMALLBLEND)) {
                rv.add(Pair.of((Object)Aspect.EXCHANGE, (Object)this.fixedValue));
                rv.add(Pair.of((Object)Aspect.CRYSTAL, (Object)this.fixedValue));
            } else if (part.equals(NameTokens.POWDER) || part.equals(NameTokens.SMALLPOWDER)) {
                rv.add(Pair.of((Object)Aspect.TOOL, (Object)this.fixedValue));
                rv.add(Pair.of((Object)Aspect.DARKNESS, (Object)this.fixedValue));
            } else if (part.equals(NameTokens.GEM) || part.equals(NameTokens.CRYSTAL) || part.equals(NameTokens.MEK_CRYSTAL)) {
                rv.add(Pair.of((Object)Aspect.CRYSTAL, (Object)this.fixedValue));
            }
        }
        return rv.isEmpty() ? Collections.emptyList() : rv;
    }

    private int doGenericMagicCalc(float multiplier) {
        float enchantability = this.wrapped.getEnchantability();
        float harvestLevel = this.wrapped.getRequiredHarvestLevel();
        return (int)(enchantability * harvestLevel * multiplier / 10.0f);
    }

    private int doGenericCalc(float multiplier) {
        float harvestLevel = this.wrapped.getRequiredHarvestLevel();
        float blockHardness = this.wrapped.getBlockHardness();
        if (blockHardness < 0.1f) {
            blockHardness = 0.1f;
        }
        float value = harvestLevel <= 0.0f ? 0.1f * blockHardness * 20.0f : (harvestLevel < 1.0f ? harvestLevel * blockHardness * 5.0f : (harvestLevel < 2.0f ? harvestLevel * blockHardness * 1.2f : (harvestLevel < 3.0f ? harvestLevel * blockHardness / 4.0f : harvestLevel * blockHardness / 6.0f)));
        if (this.wrapped.isAlloy()) {
            value *= 3.0f;
        }
        if ((value = value / 27.0f * multiplier + 1.0f) < 2.0f && value > 0.0f) {
            value += 1.0f;
        }
        return (int)value;
    }
}

