/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.integration.plugins;

import cofh.api.util.ThermalExpansionHelper;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.integration.IIntegration;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.util.Config;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ThermalExpansion
implements IIntegration {
    public static final String PLUGIN_MODID = "thermalexpansion";

    @Override
    public void init() {
        if (!Config.Options.isModEnabled(PLUGIN_MODID)) {
            return;
        }
    }

    protected static void addPulverizerRecipe(@Nonnull int energy, @Nonnull ItemStack input, @Nonnull ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b()) {
            return;
        }
        ThermalExpansionHelper.addPulverizerRecipe((int)energy, (ItemStack)input, (ItemStack)output);
    }

    protected static void addCompactorPressRecipe(@Nonnull int energy, @Nonnull ItemStack input, @Nonnull ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b()) {
            return;
        }
        ThermalExpansionHelper.addCompactorPressRecipe((int)energy, (ItemStack)input, (ItemStack)output);
    }

    protected static void addCompactorStorageRecipe(@Nonnull int energy, @Nonnull ItemStack input, @Nonnull ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b()) {
            return;
        }
        ThermalExpansionHelper.addCompactorStorageRecipe((int)energy, (ItemStack)input, (ItemStack)output);
    }

    protected static void addPulverizer(@Nonnull String materialName) {
        ThermalExpansion.addPulverizer(Materials.getMaterialByName(materialName));
    }

    protected static void addPulverizer(@Nonnull MMDMaterial material) {
        if (material.isEmpty() || !material.hasItem(Names.POWDER)) {
            return;
        }
        int ENERGY_ORE = 4000;
        int ENERGY_INGOT = 2000;
        ItemStack inputOre = ItemStack.field_190927_a;
        ItemStack inputIngot = ItemStack.field_190927_a;
        ItemStack outputDust = new ItemStack(material.getItem(Names.POWDER));
        if (material.hasBlock(Names.ORE) && material.getBlock(Names.ORE) != null) {
            inputOre = material.getBlockItemStack(Names.ORE);
        }
        if (material.hasItem(Names.INGOT) && material.getItem(Names.INGOT) != null) {
            inputIngot = material.getItemStack(Names.INGOT);
        }
        if (!inputOre.func_190926_b()) {
            ThermalExpansion.addPulverizerRecipe(4000, inputOre, outputDust);
        }
        if (!inputIngot.func_190926_b()) {
            ThermalExpansion.addPulverizerRecipe(2000, inputIngot, outputDust);
        }
    }

    protected static void addFurnace(@Nonnull String materialName) {
        ThermalExpansion.addFurnace(Materials.getMaterialByName(materialName));
    }

    protected static void addFurnace(@Nonnull MMDMaterial material) {
        ItemStack ore;
        if (material.isEmpty()) {
            return;
        }
        int ENERGY_ORE = 2000;
        int ENERGY_DUST = 1400;
        if (material.hasBlock(Names.ORE) && material.getBlock(Names.ORE) != null) {
            ore = material.getBlockItemStack(Names.ORE, 1);
        } else if (material.hasItem(Names.BLEND) && material.getItem(Names.BLEND) != null) {
            ore = material.getItemStack(Names.BLEND, 1);
        } else {
            return;
        }
        if (!material.hasItem(Names.INGOT) || material.getItem(Names.INGOT) == null) {
            return;
        }
        if (material.hasItem(Names.INGOT)) {
            ItemStack ingot = material.getItemStack(Names.INGOT, 1);
            ThermalExpansionHelper.addFurnaceRecipe((int)2000, (ItemStack)ore, (ItemStack)ingot);
            if (material.hasItem(Names.POWDER) && material.getItem(Names.POWDER) != null) {
                ItemStack dust = material.getItemStack(Names.POWDER, 1);
                ThermalExpansionHelper.addFurnaceRecipe((int)1400, (ItemStack)dust, (ItemStack)ingot);
            }
        }
    }

    protected static void addCrucible(@Nonnull String materialName) {
        ThermalExpansion.addCrucible(Materials.getMaterialByName(materialName));
    }

    protected static void addCrucible(@Nonnull MMDMaterial material) {
        FluidStack nuggetFluid;
        FluidStack baseFluid;
        FluidStack oreFluid;
        if (material.isEmpty()) {
            return;
        }
        int ENERGY_QTY = 8000;
        String materialName = material.getName();
        if (materialName.equals("redstone")) {
            oreFluid = FluidRegistry.getFluidStack((String)materialName, (int)360);
            baseFluid = FluidRegistry.getFluidStack((String)materialName, (int)100);
            nuggetFluid = FluidRegistry.getFluidStack((String)materialName, (int)0);
        } else {
            oreFluid = FluidRegistry.getFluidStack((String)materialName, (int)288);
            baseFluid = FluidRegistry.getFluidStack((String)materialName, (int)144);
            nuggetFluid = FluidRegistry.getFluidStack((String)materialName, (int)16);
        }
        if (material.hasBlock(Names.ORE) && material.getBlock(Names.ORE) != null) {
            ItemStack ore = material.getBlockItemStack(Names.ORE);
            ThermalExpansionHelper.addCrucibleRecipe((int)8000, (ItemStack)ore, (FluidStack)oreFluid);
        }
        if (material.hasItem(Names.INGOT)) {
            ItemStack ingot = material.getItemStack(Names.INGOT);
            ThermalExpansionHelper.addCrucibleRecipe((int)4000, (ItemStack)ingot, (FluidStack)baseFluid);
        }
        if (material.hasItem(Names.POWDER)) {
            ItemStack dust = material.getItemStack(Names.POWDER);
            ThermalExpansionHelper.addCrucibleRecipe((int)2000, (ItemStack)dust, (FluidStack)baseFluid);
        }
        if (material.hasBlock(Names.PLATE)) {
            ItemStack plate = material.getBlockItemStack(Names.PLATE);
            ThermalExpansionHelper.addCrucibleRecipe((int)4000, (ItemStack)plate, (FluidStack)baseFluid);
        }
        if (!materialName.equals("redstone")) {
            if (material.hasItem(Names.NUGGET)) {
                ItemStack nugget = material.getItemStack(Names.NUGGET);
                ThermalExpansionHelper.addCrucibleRecipe((int)500, (ItemStack)nugget, (FluidStack)nuggetFluid);
            }
            if (material.hasItem(Names.SMALLPOWDER)) {
                ItemStack smallPowder = material.getItemStack(Names.SMALLPOWDER);
                ThermalExpansionHelper.addCrucibleRecipe((int)250, (ItemStack)smallPowder, (FluidStack)nuggetFluid);
            }
        }
    }

    protected static void addPlatePress(@Nonnull String materialName) {
        ThermalExpansion.addPlatePress(Materials.getMaterialByName(materialName));
    }

    protected static void addPlatePress(@Nonnull MMDMaterial material) {
        if (material.isEmpty()) {
            return;
        }
        if (material.hasItem(Names.PLATE) && material.hasItem(Names.INGOT)) {
            int ENERGY_QTY = 4000;
            ThermalExpansion.addCompactorPressRecipe(4000, material.getItemStack(Names.INGOT), material.getBlockItemStack(Names.PLATE));
        }
    }

    protected static void addPressStorage(@Nonnull String materialName) {
        ThermalExpansion.addPressStorage(Materials.getMaterialByName(materialName));
    }

    protected static void addPressStorage(@Nonnull MMDMaterial material) {
        if (material.isEmpty()) {
            return;
        }
        int ENERGY_QTY = 4000;
        ItemStack ingotStack = material.getItemStack(Names.INGOT);
        ItemStack ingotsStack = material.getItemStack(Names.INGOT, 9);
        ItemStack nuggetsStack = material.getItemStack(Names.NUGGET, 9);
        ItemStack blockStack = material.getBlockItemStack(Names.BLOCK, 1);
        ThermalExpansion.addCompactorStorageRecipe(4000, ingotsStack, blockStack);
        ThermalExpansion.addCompactorStorageRecipe(4000, nuggetsStack, ingotStack);
    }
}

