/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.init;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.block.BlockMMDBookshelf;
import com.mcmoddev.lib.block.BlockMMDSlab;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.ItemGroups;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.item.ItemMMDBlock;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.util.Oredicts;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockSlab;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

public abstract class Blocks {
    private static final BiMap<String, Block> blockRegistry = HashBiMap.create((int)16);
    private static final Map<MMDMaterial, List<Block>> blocksByMaterial = new HashMap<MMDMaterial, List<Block>>();
    private static final Map<String, Class<? extends Block>> nameToClass = new HashMap<String, Class<? extends Block>>();
    private static final Map<String, String> nameToOredict = new HashMap<String, String>();
    private static final Map<String, Boolean> nameToEnabled = new HashMap<String, Boolean>();

    protected Blocks() {
        throw new IllegalAccessError("Not a instantiable class");
    }

    public static void init() {
    }

    @Nullable
    protected static Block create(@Nonnull Names name, @Nonnull String materialName) {
        return Blocks.create(name, Materials.getMaterialByName(materialName), (CreativeTabs)ItemGroups.getTab("blocks"));
    }

    @Nullable
    protected static Block create(@Nonnull Names name, @Nonnull MMDMaterial material) {
        return Blocks.create(name, material, (CreativeTabs)ItemGroups.getTab("blocks"));
    }

    @Nullable
    protected static Block create(@Nonnull Names name, @Nonnull String materialName, CreativeTabs tab) {
        return Blocks.create(name, Materials.getMaterialByName(materialName), false, tab);
    }

    @Nullable
    protected static Block create(@Nonnull Names name, @Nonnull MMDMaterial material, CreativeTabs tab) {
        return Blocks.create(name, material, false, tab);
    }

    @Nullable
    protected static Block create(@Nonnull Names name, @Nonnull String materialName, @Nonnull boolean glow, CreativeTabs tab) {
        return Blocks.create(name, Materials.getMaterialByName(materialName), glow, tab);
    }

    @Nullable
    protected static Block create(@Nonnull Names name, @Nonnull MMDMaterial material, @Nonnull boolean glows, CreativeTabs tab) {
        if (material.hasBlock(name)) {
            return material.getBlock(name);
        }
        if (Blocks.doesThisNeedBlock(name) && !material.hasBlock(Names.BLOCK) || Blocks.doesThisNeedOre(name) && !material.hasOre()) {
            return null;
        }
        Block block = Blocks.createBlock(material, name.toString(), Blocks.getClassFromName(name), Blocks.isNameEnabled(name), tab);
        String oredict = Blocks.getOredictFromName(name);
        if (oredict != null && block != null) {
            Oredicts.registerOre(oredict + material.getCapitalizedName(), block);
        }
        if (block != null && glows) {
            block.func_149715_a(0.5f);
        }
        return block;
    }

    private static boolean doesThisNeedBlock(Names name) {
        return name.equals((Object)Names.FENCE) || name.equals((Object)Names.FENCE_GATE) || name.equals((Object)Names.FLOWER_POT) || name.equals((Object)Names.LADDER) || name.equals((Object)Names.STAIRS) || name.equals((Object)Names.TRIPWIRE_HOOK) || name.equals((Object)Names.WALL);
    }

    private static boolean doesThisNeedOre(Names name) {
        return name.equals((Object)Names.ORE) || name.equals((Object)Names.ENDORE) || name.equals((Object)Names.NETHERORE);
    }

    @Nullable
    protected static Block addBlock(@Nonnull Block block, @Nonnull Names name, CreativeTabs tab) {
        return Blocks.addBlock(block, name.toString(), Materials.DEFAULT, tab);
    }

    @Nullable
    protected static Block addBlock(@Nonnull Block block, @Nonnull String name, CreativeTabs tab) {
        return Blocks.addBlock(block, name, Materials.DEFAULT, tab);
    }

    @Nullable
    protected static Block addBlock(@Nonnull Block block, @Nonnull Names name, @Nonnull MMDMaterial material, CreativeTabs tab) {
        return Blocks.addBlock(block, name.toString(), material, tab);
    }

    @Nullable
    protected static Block addBlock(@Nonnull Block block, @Nonnull String name, @Nonnull MMDMaterial material, @Nullable CreativeTabs tab) {
        String fullName = Blocks.getBlockFullName(block, material, name);
        block.setRegistryName(new ResourceLocation(Loader.instance().activeModContainer().getModId(), fullName));
        block.func_149663_c(block.getRegistryName().func_110624_b() + "." + fullName);
        Blocks.maybeMakeItemBlock(block, material, fullName);
        if (tab != null) {
            block.func_149647_a(tab);
        }
        if (!material.isEmpty()) {
            blocksByMaterial.computeIfAbsent(material, g -> new ArrayList());
            blocksByMaterial.get((Object)material).add(block);
        }
        blockRegistry.put((Object)fullName, (Object)block);
        if (material.isDefault()) {
            material.addNewBlock(fullName, block);
        }
        return block;
    }

    private static void maybeMakeItemBlock(Block block, MMDMaterial material, String fullName) {
        if (!(block instanceof BlockAnvil || block instanceof BlockDoor || block instanceof BlockSlab || material.isEmpty())) {
            ItemMMDBlock itemBlock = new ItemMMDBlock(material, block);
            itemBlock.setRegistryName(block.getRegistryName());
            itemBlock.func_77655_b(block.getRegistryName().func_110624_b() + "." + fullName);
            material.addNewItem("ItemBlock_" + fullName, (Item)itemBlock);
        }
    }

    private static String getBlockFullName(@Nonnull Block block, MMDMaterial material, @Nonnull String name) {
        if (block instanceof BlockMMDSlab.Double) {
            return String.format("double_%s_%s", new Object[]{material.getName(), Names.SLAB});
        }
        if (name.startsWith("nether") || name.startsWith("end")) {
            String neededBit = name.substring(0, name.length() - 3);
            return String.format("%s_%s_%s", new Object[]{neededBit, material.getName(), Names.ORE});
        }
        if (!material.isEmpty() && !material.isDefault()) {
            return String.format("%s_%s", material.getName(), name);
        }
        return name;
    }

    @Nullable
    private static Block createBlock(@Nonnull MMDMaterial material, @Nonnull String name, @Nonnull Class<? extends Block> clazz, @Nonnull boolean enabled, CreativeTabs tab) {
        if (enabled) {
            Constructor<? extends Block> ctor = null;
            Block inst = null;
            try {
                ctor = clazz.getConstructor(((Object)((Object)material)).getClass());
            }
            catch (Exception ex) {
                MMDLib.logger.fatal("Class for Block named %s does not have an accessible constructor or another exception occurred", (Object)name, (Object)ex);
                return null;
            }
            try {
                inst = ctor.newInstance(new Object[]{material});
            }
            catch (Exception ex) {
                MMDLib.logger.fatal("Unable to create Block named %s for material %s", (Object)name, (Object)material.getCapitalizedName(), (Object)ex);
            }
            if (inst != null) {
                material.addNewBlock(name, Blocks.addBlock(inst, name, material, tab));
                return inst;
            }
        }
        return null;
    }

    protected static Block createBookshelf(@Nonnull MMDMaterial material, @Nonnull boolean fullBlock, CreativeTabs tab) {
        BlockMMDBookshelf bs = (BlockMMDBookshelf)Blocks.create(Names.BOOKSHELF, material, tab);
        if (bs != null) {
            bs.setFullBlock(fullBlock);
        }
        return bs;
    }

    protected static Class<? extends Block> getClassFromName(@Nonnull Names name) {
        if (nameToClass.containsKey(name.toString())) {
            return nameToClass.get(name.toString());
        }
        return Block.class;
    }

    @Nullable
    protected static String getOredictFromName(@Nonnull Names name) {
        if (nameToOredict.containsKey(name.toString())) {
            return nameToOredict.get(name.toString());
        }
        return null;
    }

    protected static boolean isNameEnabled(@Nonnull Names name) {
        if (nameToEnabled.containsKey(name.toString())) {
            return nameToEnabled.get(name.toString());
        }
        return false;
    }

    protected static void addBlockType(@Nonnull Names name, @Nonnull Class<? extends Block> clazz, @Nonnull Boolean enabled) {
        Blocks.addBlockType(name, clazz, enabled, null);
    }

    protected static void addBlockType(@Nonnull Names name, @Nonnull Class<? extends Block> clazz, @Nonnull Boolean enabled, @Nullable String oredict) {
        Blocks.addBlockType(name.toString(), clazz, enabled, oredict);
    }

    protected static void addBlockType(@Nonnull String name, @Nonnull Class<? extends Block> clazz, @Nonnull Boolean enabled, @Nullable String oredict) {
        MMDLib.logger.debug("Register Block Type: {}/{}/{}/{}", (Object)name, (Object)clazz.getName(), (Object)enabled, (Object)(oredict == null ? "null" : ("".contentEquals(oredict) ? "EMPTY" : oredict)));
        if (!nameToClass.containsKey(name)) {
            nameToClass.put(name, clazz);
        }
        if (!nameToEnabled.containsKey(name)) {
            nameToEnabled.put(name, enabled);
        }
        if (oredict != null && !"".equals(oredict) && !nameToOredict.containsKey(name)) {
            nameToOredict.put(name, oredict);
        }
    }

    @Nullable
    public static Block getBlockByName(@Nonnull String name) {
        return (Block)blockRegistry.get((Object)name);
    }

    @Nullable
    public static String getNameOfBlock(@Nonnull Block block) {
        return (String)blockRegistry.inverse().get((Object)block);
    }

    public static Map<String, Block> getBlockRegistry() {
        return Collections.unmodifiableMap(blockRegistry);
    }

    public static Map<MMDMaterial, List<Block>> getBlocksByMaterial() {
        return Collections.unmodifiableMap(blocksByMaterial);
    }
}

