/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.feature;

import com.mcmoddev.lib.capability.ICapabilitiesContainer;
import com.mcmoddev.lib.feature.IClientFeature;
import com.mcmoddev.lib.feature.IFeature;
import com.mcmoddev.lib.feature.IFeatureHolder;
import com.mcmoddev.lib.feature.IServerFeature;
import com.mcmoddev.lib.feature.ISidedFeature;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class SidedFeatureWrapper
implements IFeature,
IClientFeature,
IServerFeature,
ISidedFeature,
ICapabilityProvider {
    private EnumFacing[] facings = null;
    private boolean dirty = false;
    private final IFeature feature;
    private final IClientFeature clientFeature;
    private final IServerFeature serverFeature;
    private final ICapabilityProvider capProvider;
    private final int color;
    private final int priorityIndex;

    public SidedFeatureWrapper(IFeature feature, int color, int priorityIndex) {
        this.feature = feature;
        this.clientFeature = feature instanceof IClientFeature ? (IClientFeature)feature : null;
        this.serverFeature = feature instanceof IServerFeature ? (IServerFeature)feature : null;
        this.capProvider = feature instanceof ICapabilityProvider ? (ICapabilityProvider)feature : null;
        this.color = color;
        this.priorityIndex = priorityIndex;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public int getPriorityIndex() {
        return this.priorityIndex;
    }

    @Override
    public String getKey() {
        return this.feature.getKey();
    }

    @Override
    @Nullable
    public IFeatureHolder getHolder() {
        return this.feature.getHolder();
    }

    @Override
    public void setHolder(@Nullable IFeatureHolder holder) {
        this.feature.setHolder(holder);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = (NBTTagCompound)this.feature.serializeNBT();
        this.writeToNBT(tag);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.feature.deserializeNBT((NBTBase)nbt);
        this.readFromNBT(nbt);
        this.dirty = false;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        if (this.clientFeature != null) {
            this.clientFeature.handleUpdateTag(tag);
        }
        this.readFromNBT(tag);
    }

    @Override
    public boolean isDirty() {
        return this.dirty || this.serverFeature != null && this.serverFeature.isDirty();
    }

    @Override
    @Nullable
    public NBTTagCompound getGuiUpdateTag(boolean resetDirtyFlag) {
        return this.serverFeature != null ? this.serverFeature.getGuiUpdateTag(resetDirtyFlag) : null;
    }

    @Override
    @Nullable
    public NBTTagCompound getTickUpdateTag(boolean resetDirtyFlag) {
        NBTTagCompound nbt;
        NBTTagCompound nBTTagCompound = nbt = this.serverFeature != null ? this.serverFeature.getTickUpdateTag(resetDirtyFlag) : null;
        if (this.dirty) {
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            this.writeToNBT(nbt);
            if (resetDirtyFlag) {
                this.dirty = false;
            }
        }
        return nbt;
    }

    @Override
    @Nullable
    public NBTTagCompound getLoadUpdateTag() {
        NBTTagCompound tag;
        NBTTagCompound nBTTagCompound = tag = this.serverFeature != null ? this.serverFeature.getLoadUpdateTag() : null;
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        this.writeToNBT(tag);
        this.dirty = false;
        return tag;
    }

    @Override
    public EnumFacing[] getFacings() {
        return this.facings == null ? new EnumFacing[]{} : this.facings;
    }

    @Override
    public void setFacings(EnumFacing[] facings) {
        this.facings = facings;
        this.dirty = true;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.capProvider != null && (facing == null || this.isFacingEnabled(facing)) && this.capProvider.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.capProvider != null && (facing == null || this.isFacingEnabled(facing))) {
            return (T)this.capProvider.getCapability(capability, facing);
        }
        return null;
    }

    @Override
    public void initCapabilities(final ICapabilitiesContainer container) {
        ICapabilitiesContainer fake = new ICapabilitiesContainer(){

            @Override
            public <T> void addCapability(Capability<T> capability, Function<EnumFacing, T> capabilitySupplier, @Nullable Predicate<EnumFacing> facingFilter) {
                container.addCapability(capability, capabilitySupplier, facing -> (facingFilter == null || facingFilter.test((EnumFacing)facing)) && SidedFeatureWrapper.this.isFacingEnabled((EnumFacing)facing));
            }
        };
        this.feature.initCapabilities(fake);
    }

    protected void writeToNBT(NBTTagCompound tag) {
        if (this.facings != null && this.facings.length > 0) {
            this.serializeNBT().func_74782_a("facings", (NBTBase)new NBTTagIntArray(Arrays.stream(this.getFacings()).map(EnumFacing::func_176745_a).collect(Collectors.toList())));
        }
    }

    protected void readFromNBT(NBTTagCompound nbt) {
        this.facings = nbt.func_150297_b("facings", 11) ? (EnumFacing[])Arrays.stream(nbt.func_74759_k("facings")).mapToObj(EnumFacing::func_82600_a).toArray(EnumFacing[]::new) : new EnumFacing[0];
    }
}

