/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.energy.rf;

import cofh.redstoneflux.api.IEnergyContainerItem;
import com.mcmoddev.lib.energy.EnergySystemRegistry;
import com.mcmoddev.lib.energy.IEnergyAdapter;
import com.mcmoddev.lib.energy.IEnergySystem;
import com.mcmoddev.lib.energy.IEnergyValue;
import com.mcmoddev.lib.energy.rf.RFEnergyValue;
import net.minecraft.item.ItemStack;

public class RFEnergyAdapterItem
implements IEnergyAdapter {
    private final IEnergyContainerItem container;
    private final ItemStack stack;

    public RFEnergyAdapterItem(IEnergyContainerItem container, ItemStack stack) {
        this.container = container;
        this.stack = stack;
    }

    @Override
    public IEnergySystem getSystem() {
        return EnergySystemRegistry.RF;
    }

    private RFEnergyValue makeValue(int value) {
        return new RFEnergyValue(value);
    }

    @Override
    public IEnergyValue getCapacity() {
        return this.makeValue(this.container.getMaxEnergyStored(this.stack));
    }

    @Override
    public IEnergyValue getValue() {
        return this.makeValue(this.container.getEnergyStored(this.stack));
    }

    @Override
    public IEnergyValue charge(IEnergyValue value, boolean doCharge) {
        IEnergyValue ours = this.getSystem().convertFrom(value);
        if (ours instanceof RFEnergyValue) {
            int energy = (Integer)((RFEnergyValue)ours).getValue();
            return this.makeValue(this.container.receiveEnergy(this.stack, energy, !doCharge));
        }
        return this.makeValue(0);
    }

    @Override
    public IEnergyValue discharge(IEnergyValue value, boolean doDischarge) {
        IEnergyValue ours = this.getSystem().convertFrom(value);
        if (ours instanceof RFEnergyValue) {
            int energy = (Integer)((RFEnergyValue)ours).getValue();
            return this.makeValue(this.container.extractEnergy(this.stack, energy, !doDischarge));
        }
        return this.makeValue(0);
    }
}

