/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.energy.rf;

import cofh.redstoneflux.api.IEnergyHandler;
import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import com.mcmoddev.lib.energy.EnergySystemRegistry;
import com.mcmoddev.lib.energy.IEnergyAdapter;
import com.mcmoddev.lib.energy.IEnergySystem;
import com.mcmoddev.lib.energy.IEnergyValue;
import com.mcmoddev.lib.energy.rf.RFEnergyValue;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;

public class RFEnergyAdapter
implements IEnergyAdapter {
    private final IEnergyReceiver receiver;
    private final IEnergyHandler handler;
    private final IEnergyProvider provider;
    private final EnumFacing facing;

    public RFEnergyAdapter(@Nullable IEnergyReceiver receiver, @Nullable IEnergyProvider provider, @Nullable EnumFacing facing) {
        this.receiver = receiver;
        this.provider = provider;
        this.handler = receiver == null ? provider : receiver;
        this.facing = facing;
    }

    @Override
    public IEnergySystem getSystem() {
        return EnergySystemRegistry.RF;
    }

    private RFEnergyValue makeValue(int value) {
        return new RFEnergyValue(value);
    }

    @Override
    public IEnergyValue getCapacity() {
        return this.makeValue(this.handler == null ? 0 : this.handler.getMaxEnergyStored(this.facing));
    }

    @Override
    public IEnergyValue getValue() {
        return this.makeValue(this.handler == null ? 0 : this.handler.getEnergyStored(this.facing));
    }

    @Override
    public IEnergyValue charge(IEnergyValue value, boolean doCharge) {
        IEnergyValue ours;
        if (this.receiver != null && (ours = this.getSystem().convertFrom(value)) instanceof RFEnergyValue) {
            int energy = (Integer)((RFEnergyValue)ours).getValue();
            return this.makeValue(this.receiver.receiveEnergy(this.facing, energy, !doCharge));
        }
        return this.makeValue(0);
    }

    @Override
    public IEnergyValue discharge(IEnergyValue value, boolean doDischarge) {
        IEnergyValue ours;
        if (this.provider != null && (ours = this.getSystem().convertFrom(value)) instanceof RFEnergyValue) {
            int energy = (Integer)((RFEnergyValue)ours).getValue();
            return this.makeValue(this.provider.extractEnergy(this.facing, energy, !doDischarge));
        }
        return this.makeValue(0);
    }
}

