/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.energy;

import com.mcmoddev.lib.energy.IEnergySystem;
import com.mcmoddev.lib.energy.IEnergyValue;
import com.mcmoddev.lib.energy.IGenericEnergyStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class BaseGenericEnergyStorage<T>
implements IGenericEnergyStorage<T>,
INBTSerializable<NBTTagCompound>,
ICapabilityProvider {
    private IEnergyValue<T> stored;
    private final IEnergyValue<T> capacity;
    private final List<IEnergySystem> acceptedSystems;
    private IEnergyValue<T> inputRate;
    private IEnergyValue<T> outputRate;
    private final List<Runnable> onChangeListeners = new ArrayList<Runnable>();

    protected BaseGenericEnergyStorage(IEnergyValue<T> initial, IEnergyValue<T> capacity, IEnergySystem ... acceptedSystems) {
        this.stored = initial;
        this.capacity = capacity;
        this.acceptedSystems = Arrays.asList(acceptedSystems);
    }

    @Override
    public IEnergySystem<T> getBaseSystem() {
        return this.capacity.getSystem();
    }

    @Override
    public IEnergyValue<T> getCapacityValue() {
        return this.capacity.copy();
    }

    @Override
    public IEnergyValue<T> getStoredValue() {
        return this.stored.copy();
    }

    @Override
    public T getCapacity() {
        return this.capacity.getValue();
    }

    @Override
    public T getStored() {
        return this.stored.getValue();
    }

    @Override
    public IEnergyValue<T> getInputRateValue() {
        return this.inputRate.copy();
    }

    @Override
    public IEnergyValue<T> getOutputRateValue() {
        return this.outputRate.copy();
    }

    protected void setInputRateValue(IEnergyValue<T> value) {
        this.inputRate = value;
        this.onChanged();
    }

    protected void setOutputRateValue(IEnergyValue<T> value) {
        this.outputRate = value;
        this.onChanged();
    }

    @Override
    public T getInputRate() {
        return this.inputRate.getValue();
    }

    @Override
    public T getOutputRate() {
        return this.outputRate.getValue();
    }

    @Override
    public boolean canStore() {
        return this.getZeroEnergy().compareTo(this.inputRate) < 0;
    }

    @Override
    public boolean canTake() {
        return this.getZeroEnergy().compareTo(this.outputRate) < 0;
    }

    public final NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeValueToNBT(nbt, "energy", this.getStored());
        this.writeValueToNBT(nbt, "input_rate", this.getInputRate());
        this.writeValueToNBT(nbt, "output_rate", this.getOutputRate());
        return nbt;
    }

    protected abstract void writeValueToNBT(NBTTagCompound var1, String var2, T var3);

    public final void deserializeNBT(NBTTagCompound nbt) {
        this.stored = nbt == null || !nbt.func_74764_b("energy") ? this.getZeroEnergy() : this.readValueFromNBT(nbt, "energy");
        this.inputRate = nbt == null || !nbt.func_74764_b("input_rate") ? this.getZeroEnergy() : this.readValueFromNBT(nbt, "input_rate");
        this.outputRate = nbt == null || !nbt.func_74764_b("output_rate") ? this.getZeroEnergy() : this.readValueFromNBT(nbt, "output_rate");
    }

    protected abstract IEnergyValue<T> getZeroEnergy();

    protected abstract IEnergyValue<T> readValueFromNBT(NBTTagCompound var1, String var2);

    @Override
    public IEnergyValue<T> storeValue(IEnergyValue toStore, boolean doStore) {
        IEnergyValue<T> canStore;
        IEnergyValue<T> normalized = this.capacity.getSystem().convertFrom(toStore);
        if (normalized == null) {
            return this.getZeroEnergy();
        }
        IEnergyValue<T> available = this.capacity.subtract(this.stored);
        IEnergyValue<T> iEnergyValue = canStore = available.compareTo(normalized) < 0 ? available.copy() : normalized.copy();
        if (doStore && canStore.compareTo(this.getZeroEnergy()) > 0) {
            this.stored = this.stored.add(canStore);
            this.onChanged();
        }
        return canStore;
    }

    @Override
    public IEnergyValue<T> takeValue(IEnergyValue toTake, boolean doTake) {
        IEnergyValue<T> canTake;
        IEnergyValue<T> normalized = this.capacity.getSystem().convertFrom(toTake);
        if (normalized == null) {
            return this.getZeroEnergy();
        }
        IEnergyValue<T> iEnergyValue = canTake = this.stored.compareTo(normalized) < 0 ? this.stored.copy() : normalized.copy();
        if (doTake && canTake.compareTo(this.getZeroEnergy()) > 0) {
            this.stored = this.stored.subtract(canTake);
            this.onChanged();
        }
        return canTake;
    }

    protected void onChanged() {
        for (Runnable listener : this.onChangeListeners) {
            listener.run();
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.acceptedSystems.stream().anyMatch(s -> s.hasCapability(capability, this));
    }

    @Nullable
    public <C> C getCapability(@Nonnull Capability<C> capability, @Nullable EnumFacing facing) {
        return this.acceptedSystems.stream().map(s -> s.getCapability(capability, this)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private void addOnChangeListener(Runnable listener) {
        this.onChangeListeners.add(listener);
    }

    public ICapabilityProvider getProviderForItemStack(ItemStack stack) {
        return this.getProviderForItemStack(stack, null, null);
    }

    public ICapabilityProvider getProviderForItemStack(final ItemStack stack, final @Nullable BiPredicate<ItemStack, Capability> capabilityPreFilter, @Nullable BiConsumer<ItemStack, IEnergyStorage> changedUpdate) {
        this.addOnChangeListener(() -> {
            stack.func_77983_a("mmd_battery", (NBTBase)this.serializeNBT());
            if (changedUpdate != null) {
                changedUpdate.accept(stack, (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, null));
            }
        });
        if (stack.func_179543_a("mod_battery") == null) {
            this.onChanged();
        }
        return new ICapabilityProvider(){

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return (capabilityPreFilter == null || capabilityPreFilter.test(stack, capability)) && BaseGenericEnergyStorage.this.hasCapability(capability, facing);
            }

            @Nullable
            public <C> C getCapability(@Nonnull Capability<C> capability, @Nullable EnumFacing facing) {
                if (!this.hasCapability(capability, facing)) {
                    return null;
                }
                BaseGenericEnergyStorage.this.deserializeNBT(stack.func_179543_a("mmd_battery"));
                return BaseGenericEnergyStorage.this.getCapability(capability, facing);
            }
        };
    }
}

