/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.container.widget;

import com.mcmoddev.lib.container.widget.ActionWidget;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ActionTextWidget
extends ActionWidget {
    public static final String NBT_TEXT_KEY = "_text";
    private String text;

    public ActionTextWidget(String key, String initialText) {
        super(key, true);
        this.text = initialText;
    }

    public String getText() {
        return this.text;
    }

    public void setText(@Nullable String text) {
        if (text == null && this.text == null || this.text != null && this.text.equals(text)) {
            return;
        }
        this.text = text;
        this.setDirty();
    }

    public ActionTextWidget setClientSideTextConsumer(Consumer<String> consumer) {
        super.setClientSideConsumer((NBTTagCompound nbt) -> consumer.accept(this.getTextFromNBT((NBTTagCompound)nbt)));
        return this;
    }

    public ActionTextWidget setServerSideTextConsumer(Consumer<String> consumer) {
        super.setServerSideConsumer((NBTTagCompound nbt) -> consumer.accept(this.getTextFromNBT((NBTTagCompound)nbt)));
        return this;
    }

    @Override
    @Nullable
    public NBTTagCompound getUpdateCompound() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.text != null) {
            nbt.func_74778_a(NBT_TEXT_KEY, this.text);
        }
        return nbt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleMessageFromServer(NBTTagCompound tag) {
        this.text = this.getTextFromNBT(tag);
        super.handleMessageFromServer(tag);
    }

    @Override
    public void handleMessageFromClient(NBTTagCompound tag) {
        this.setText(this.getTextFromNBT(tag));
        super.handleMessageFromClient(tag);
    }

    @Nullable
    private String getTextFromNBT(NBTTagCompound tag) {
        return tag.func_150297_b(NBT_TEXT_KEY, 8) ? tag.func_74779_i(NBT_TEXT_KEY) : null;
    }

    @SideOnly(value=Side.CLIENT)
    public static NBTTagCompound getActionNBT(@Nullable String newText) {
        NBTTagCompound data = new NBTTagCompound();
        if (newText != null) {
            data.func_74778_a(NBT_TEXT_KEY, newText);
        }
        return data;
    }
}

