/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.container.gui.util;

import com.mcmoddev.lib.container.gui.IGuiSprite;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class TexturedRectangleRenderer {
    private TexturedRectangleRenderer() {
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawOnGUI(GuiScreen screen, IGuiSprite sprite, int borderSize, int width, int height) {
        TexturedRectangleRenderer.drawOnGUI(screen, sprite, borderSize, 1, width, height);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawOnGUI(GuiScreen screen, IGuiSprite sprite, int borderSize, int overlap, int width, int height) {
        TexturedRectangleRenderer.drawOnGUI(screen, sprite, borderSize, overlap, 0, 0, width, height);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawOnGUI(GuiScreen screen, IGuiSprite sprite, int borderSize, int overlap, int left, int top, int width, int height) {
        int innerWidth = sprite.getWidth() - borderSize * 2;
        int innerHeight = sprite.getHeight() - borderSize * 2;
        int innerRows = (int)Math.ceil((double)(height - borderSize * 2) / (double)innerHeight);
        int innerColumns = (int)Math.ceil((double)(width - borderSize * 2) / (double)innerWidth);
        sprite.getTexture().bind();
        for (int r = 0; r < innerRows; ++r) {
            int renderTop = borderSize + r * innerHeight;
            int renderBottom = Math.min(renderTop + innerHeight, height - borderSize);
            if (renderBottom <= renderTop) continue;
            for (int c = 0; c < innerColumns; ++c) {
                int renderLeft = borderSize + c * innerWidth;
                int renderRight = Math.min(renderLeft + innerWidth, width - borderSize);
                if (renderRight <= renderLeft) continue;
                screen.func_73729_b(left + renderLeft, top + renderTop, sprite.getLeft() + borderSize, sprite.getTop() + borderSize, renderRight - renderLeft, renderBottom - renderTop);
            }
            screen.func_73729_b(left, top + renderTop, sprite.getLeft(), sprite.getTop() + borderSize, borderSize + overlap, renderBottom - renderTop);
            screen.func_73729_b(left + width - borderSize - overlap, top + renderTop, sprite.getLeft() + sprite.getWidth() - borderSize - overlap, sprite.getTop() + borderSize, borderSize + overlap, renderBottom - renderTop);
        }
        for (int c = 0; c < innerColumns; ++c) {
            int renderLeft = borderSize + c * innerWidth;
            int renderRight = Math.min(renderLeft + innerWidth, width - borderSize);
            if (renderRight <= renderLeft) continue;
            screen.func_73729_b(left + renderLeft, top, sprite.getLeft() + borderSize, sprite.getTop(), renderRight - renderLeft, borderSize + overlap);
            screen.func_73729_b(left + renderLeft, top + height - borderSize - overlap, sprite.getLeft() + borderSize, sprite.getTop() + sprite.getHeight() - borderSize - overlap, renderRight - renderLeft, borderSize + overlap);
        }
        screen.func_73729_b(left, top, sprite.getLeft(), sprite.getTop(), borderSize + overlap, borderSize + overlap);
        screen.func_73729_b(left, top + height - borderSize - overlap, sprite.getLeft(), sprite.getTop() + sprite.getHeight() - borderSize - overlap, borderSize + overlap, borderSize + overlap);
        screen.func_73729_b(left + width - borderSize - overlap, top + height - borderSize - overlap, sprite.getLeft() + sprite.getWidth() - borderSize - overlap, sprite.getTop() + sprite.getHeight() - borderSize - overlap, borderSize + overlap, borderSize + overlap);
        screen.func_73729_b(left + width - borderSize - overlap, top, sprite.getLeft() + sprite.getWidth() - borderSize - overlap, sprite.getTop(), borderSize + overlap, borderSize + overlap);
    }
}

