/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.container.gui.layout;

import com.mcmoddev.lib.container.gui.GuiPieceLayer;
import com.mcmoddev.lib.container.gui.IWidgetGui;
import com.mcmoddev.lib.container.gui.IWidgetGuiDebugInfo;
import com.mcmoddev.lib.container.gui.IWidgetLayout;
import com.mcmoddev.lib.container.gui.MMDGuiContainer;
import com.mcmoddev.lib.container.gui.util.Padding;
import com.mcmoddev.lib.container.gui.util.Size2D;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.util.TriConsumer;

@SideOnly(value=Side.CLIENT)
public abstract class BaseLayout
implements IWidgetLayout,
IWidgetGuiDebugInfo {
    public static final float CHILD_Z_INCREASE = 0.01f;
    private Padding padding = Padding.EMPTY;
    private boolean visible = true;
    private IWidgetLayout parentLayout = null;

    protected void onChildAdded(IWidgetGui child) {
        child.setParentLayout(this);
    }

    @Override
    public Padding getPadding() {
        return this.padding;
    }

    @Override
    public IWidgetGui setPadding(Padding value) {
        this.padding = value;
        return this;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean setVisibility(boolean isVisible) {
        if (this.canChangeVisibility()) {
            this.visible = isVisible;
        }
        return this.visible;
    }

    protected boolean canChangeVisibility() {
        return true;
    }

    @Override
    @Nullable
    public IWidgetLayout getParentLayout() {
        return this.parentLayout;
    }

    @Override
    public IWidgetGui setParentLayout(@Nullable IWidgetLayout layout) {
        this.parentLayout = layout;
        return this;
    }

    @Override
    public GuiPieceLayer[] getLayers() {
        return (GuiPieceLayer[])this.getChildren().stream().flatMap(p -> Arrays.stream(p.getLayers())).distinct().toArray(GuiPieceLayer[]::new);
    }

    @Override
    public void drawBackgroundLayer(MMDGuiContainer container, float partialTicks, int mouseX, int mouseY) {
        this.getChildren().stream().filter(p -> p.rendersInLayer(GuiPieceLayer.BACKGROUND)).forEach(piece -> this.renderPiece((IWidgetGui)piece, mouseX, mouseY, (TriConsumer<IWidgetGui, Integer, Integer>)((TriConsumer)(p, x, y) -> p.drawBackgroundLayer(container, partialTicks, (int)x, (int)y))));
    }

    @Override
    public void drawMiddleLayer(MMDGuiContainer container, float partialTicks, int mouseX, int mouseY) {
        this.getChildren().stream().filter(p -> p.rendersInLayer(GuiPieceLayer.MIDDLE)).forEach(piece -> this.renderPiece((IWidgetGui)piece, mouseX, mouseY, (TriConsumer<IWidgetGui, Integer, Integer>)((TriConsumer)(p, x, y) -> p.drawMiddleLayer(container, partialTicks, (int)x, (int)y))));
    }

    @Override
    public void drawForegroundLayer(MMDGuiContainer container, int mouseX, int mouseY) {
        this.getChildren().stream().filter(p -> p.rendersInLayer(GuiPieceLayer.FOREGROUND)).forEach(piece -> this.renderPiece((IWidgetGui)piece, mouseX, mouseY, (TriConsumer<IWidgetGui, Integer, Integer>)((TriConsumer)(p, x, y) -> p.drawForegroundLayer(container, (int)x, (int)y))));
    }

    @Override
    public void drawForegroundTopLayer(MMDGuiContainer container, int mouseX, int mouseY) {
        this.getChildren().stream().filter(p -> p.rendersInLayer(GuiPieceLayer.TOP)).forEach(piece -> this.renderPiece((IWidgetGui)piece, mouseX, mouseY, (TriConsumer<IWidgetGui, Integer, Integer>)((TriConsumer)(p, x, y) -> p.drawForegroundTopLayer(container, (int)x, (int)y))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderPiece(IWidgetGui piece, int mouseX, int mouseY, TriConsumer<IWidgetGui, Integer, Integer> renderer) {
        try {
            GlStateManager.func_179094_E();
            Size2D offset = this.getChildPosition(piece);
            GlStateManager.func_179109_b((float)offset.width, (float)offset.height, (float)0.01f);
            renderer.accept((Object)piece, (Object)(mouseX - offset.width), (Object)(mouseY - offset.height));
        }
        finally {
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public String getDebugInfo() {
        Size2D size = this.getSize();
        return String.format("[cw: %d, ch: %d]", size.width, size.height);
    }

    @Override
    public boolean mouseClicked(MMDGuiContainer container, int mouseX, int mouseY, int mouseButton) {
        for (IWidgetGui child : this.getChildren()) {
            Size2D pos = this.getChildPosition(child);
            if (mouseX < pos.width || mouseY < pos.height) continue;
            Size2D size = child.getSize();
            int localX = mouseX - pos.width;
            int localY = mouseY - pos.height;
            if (localX > size.width || localY > size.height || !child.mouseClicked(container, localX, localY, mouseButton)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(MMDGuiContainer container, int mouseX, int mouseY, int state) {
        for (IWidgetGui child : this.getChildren()) {
            Size2D pos = this.getChildPosition(child);
            if (mouseX < pos.width || mouseY < pos.height) continue;
            Size2D size = child.getSize();
            int localX = mouseX - pos.width;
            int localY = mouseY - pos.height;
            if (localX > size.width || localY > size.height || !child.mouseReleased(container, localX, localY, state)) continue;
            return true;
        }
        return false;
    }
}

