/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.container.gui;

import com.mcmoddev.lib.container.gui.GuiContext;
import com.mcmoddev.lib.container.gui.GuiPieceLayer;
import com.mcmoddev.lib.container.gui.IWidgetLayout;
import com.mcmoddev.lib.container.gui.MMDGuiContainer;
import com.mcmoddev.lib.container.gui.util.Padding;
import com.mcmoddev.lib.container.gui.util.Size2D;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public interface IWidgetGui {
    default public GuiPieceLayer getLayer() {
        return GuiPieceLayer.BACKGROUND;
    }

    default public GuiPieceLayer[] getLayers() {
        return new GuiPieceLayer[]{this.getLayer()};
    }

    default public boolean rendersInLayer(GuiPieceLayer layer) {
        for (GuiPieceLayer pieceLayer : this.getLayers()) {
            if (pieceLayer != layer) continue;
            return true;
        }
        return false;
    }

    public Size2D getSize();

    public Padding getPadding();

    public IWidgetGui setPadding(Padding var1);

    default public boolean capturesMouseOnClick() {
        return false;
    }

    default public boolean mouseClicked(MMDGuiContainer container, int mouseX, int mouseY, int mouseButton) {
        return false;
    }

    default public boolean mouseClickMove(MMDGuiContainer container, int mouseX, int mouseY, int mouseButton) {
        return false;
    }

    default public boolean mouseReleased(MMDGuiContainer container, int mouseX, int mouseY, int state) {
        return false;
    }

    default public void drawBackgroundLayer(MMDGuiContainer container, float partialTicks, int mouseX, int mouseY) {
    }

    default public void drawMiddleLayer(MMDGuiContainer container, float partialTicks, int mouseX, int mouseY) {
    }

    default public void drawForegroundLayer(MMDGuiContainer container, int mouseX, int mouseY) {
    }

    default public void drawForegroundTopLayer(MMDGuiContainer container, int mouseX, int mouseY) {
    }

    default public void getTooltip(List<String> lines) {
    }

    default public boolean isVisible() {
        return true;
    }

    public boolean setVisibility(boolean var1);

    @Nullable
    public IWidgetLayout getParentLayout();

    public IWidgetGui setParentLayout(@Nullable IWidgetLayout var1);

    default public Size2D getRenderOffset() {
        int left = 0;
        int top = 0;
        IWidgetLayout layout = this.getParentLayout();
        if (layout != null) {
            Size2D offset = layout.getRenderOffset();
            Size2D position = layout.getChildPosition(this);
            left = offset.width + position.width;
            top = offset.height + position.height;
        }
        return new Size2D(left, top);
    }

    default public void init(GuiContext context) {
    }

    default public void postInit(GuiContext context) {
    }

    default public void tick(GuiContext context) {
    }
}

