/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.container;

import com.google.common.collect.Lists;
import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.container.IContainerSlot;
import com.mcmoddev.lib.container.IWidgetContainer;
import com.mcmoddev.lib.container.gui.GuiContext;
import com.mcmoddev.lib.container.widget.IContextualWidget;
import com.mcmoddev.lib.container.widget.IProxyWidget;
import com.mcmoddev.lib.container.widget.IWidget;
import com.mcmoddev.lib.network.MMDMessages;
import com.mcmoddev.lib.network.NBTBasedPlayerMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class MMDContainer
extends Container {
    private static final double MAX_INTERACT_DISTANCE = 64.0;
    private final IWidgetContainer provider;
    private final EntityPlayer player;
    private final List<IWidget> widgets;

    public MMDContainer(IWidgetContainer provider, EntityPlayer player) {
        this.provider = provider;
        this.player = player;
        GuiContext context = new GuiContext(player, this, provider);
        this.widgets = this.provider.getWidgets(context).stream().map(w -> w instanceof IProxyWidget ? ((IProxyWidget)w).getContextualWidget(context) : w).collect(Collectors.toList());
        ArrayList slots = Lists.newArrayList();
        for (IWidget widget : this.widgets) {
            if (widget instanceof IContextualWidget) {
                ((IContextualWidget)widget).setContext(context);
            }
            slots.addAll(widget.getSlots());
        }
        MMDLib.logger.info("MMD CONTAINER created with " + slots.size() + " slots.");
        for (IContainerSlot slot : slots) {
            Slot realSlot = slot.getSlot();
            this.func_75146_a(realSlot);
            slot.setIndex(realSlot.field_75222_d);
        }
    }

    public IWidgetContainer getProvider() {
        return this.provider;
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        if (!this.provider.isValid()) {
            return false;
        }
        long playerReach = Math.round(playerIn.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e());
        int distance = this.provider.getDistance(playerIn);
        return (double)distance <= Math.min(64.0, (double)playerReach);
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        return ItemStack.field_190927_a;
    }

    public void handleMessageFromServer(NBTTagCompound compound) {
        if (compound.func_186856_d() > 0) {
            for (IWidget widget : this.widgets) {
                if (!compound.func_150297_b(widget.getKey(), 10)) continue;
                widget.handleMessageFromServer(compound.func_74775_l(widget.getKey()));
            }
        }
        if (this.provider != null) {
            this.provider.receiveGuiUpdateTag(compound);
        }
    }

    public void handleMessageFromClient(NBTTagCompound compound) {
        if (compound.func_186856_d() > 0) {
            for (IWidget widget : this.widgets) {
                if (!compound.func_150297_b(widget.getKey(), 10)) continue;
                widget.handleMessageFromClient(compound.func_74775_l(widget.getKey()));
            }
        }
    }

    @Nullable
    public IWidget findWidgetByKey(String widgetKey) {
        for (IWidget widget : this.widgets) {
            if (!widgetKey.equals(widget.getKey())) continue;
            return widget;
        }
        return null;
    }

    public List<IWidget> getWidgets() {
        return this.widgets;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.player instanceof EntityPlayerMP) {
            NBTTagCompound nbt = this.provider.getGuiUpdateTag(true);
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            for (IWidget widget : this.widgets) {
                if (!widget.isDirty()) continue;
                NBTTagCompound widgetNbt = widget.getUpdateCompound();
                if (widgetNbt != null && widgetNbt.func_186856_d() > 0) {
                    nbt.func_74782_a(widget.getKey(), (NBTBase)widgetNbt);
                }
                widget.resetDirtyFlag();
            }
            if (nbt.func_186856_d() > 0) {
                MMDMessages.sendToPlayer((EntityPlayerMP)this.player, new NBTBasedPlayerMessage(this.player, nbt));
            }
        }
    }
}

