/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.container;

import com.mcmoddev.lib.container.IGuiProvider;
import com.mcmoddev.lib.container.IItemGuiProvider;
import com.mcmoddev.lib.container.IWidgetContainer;
import com.mcmoddev.lib.container.MMDContainer;
import com.mcmoddev.lib.container.gui.GuiContext;
import com.mcmoddev.lib.container.gui.IWidgetGui;
import com.mcmoddev.lib.container.gui.MMDGuiContainer;
import com.mcmoddev.lib.container.gui.layout.VerticalStackLayout;
import com.mcmoddev.lib.container.widget.IWidget;
import com.mcmoddev.lib.feature.IClientFeature;
import com.mcmoddev.lib.feature.IFeature;
import com.mcmoddev.lib.feature.IFeatureHolder;
import com.mcmoddev.lib.feature.IItemStackFeatureHolder;
import com.mcmoddev.lib.feature.IServerFeature;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BaseItemStackWidgetProvider
implements IGuiProvider,
IWidgetContainer {
    private final ItemStack stack;
    private final Item item;
    private final IFeatureHolder features;

    public BaseItemStackWidgetProvider(ItemStack stack) {
        this(stack, stack.func_77973_b());
    }

    public BaseItemStackWidgetProvider(ItemStack stack, Item item) {
        this.stack = stack;
        this.item = item;
        this.features = this.item instanceof IItemStackFeatureHolder ? ((IItemStackFeatureHolder)IItemStackFeatureHolder.class.cast(this.item)).getFeatureHolder(this.stack) : (this.item instanceof IFeatureHolder ? (IFeatureHolder)IFeatureHolder.class.cast(this.item) : null);
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGui(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (this.item instanceof IItemGuiProvider) {
            IItemGuiProvider.GuiType type = id == 1 ? IItemGuiProvider.GuiType.AIR : IItemGuiProvider.GuiType.BLOCK;
            return ((IItemGuiProvider)IItemGuiProvider.class.cast(this.item)).getClientGui(type, this.stack, player, world, x, y, z);
        }
        Container container = this.getServerGui(id, player, world, x, y, z);
        if (container instanceof MMDContainer) {
            return new MMDGuiContainer(this, player, (MMDContainer)((Object)MMDContainer.class.cast(container)));
        }
        return null;
    }

    @Override
    @Nullable
    public Container getServerGui(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (this.item instanceof IItemGuiProvider) {
            IItemGuiProvider.GuiType type = id == 1 ? IItemGuiProvider.GuiType.AIR : IItemGuiProvider.GuiType.BLOCK;
            return ((IItemGuiProvider)IItemGuiProvider.class.cast(this.item)).getServerGui(type, this.stack, player, world, x, y, z);
        }
        return new MMDContainer(this, player);
    }

    @Override
    public List<IWidget> getWidgets(GuiContext context) {
        ArrayList<IWidget> widgets = new ArrayList<IWidget>();
        if (this.features != null) {
            for (IFeature feature : this.features.getFeatures()) {
                if (!(feature instanceof IWidgetContainer)) continue;
                widgets.addAll(((IWidgetContainer)IWidgetContainer.class.cast(feature)).getWidgets(context));
            }
        }
        return widgets;
    }

    @Override
    public IWidgetGui getRootWidgetGui(GuiContext context) {
        VerticalStackLayout layout = new VerticalStackLayout();
        if (this.features != null) {
            for (IFeature feature : this.features.getFeatures()) {
                if (!(feature instanceof IWidgetContainer)) continue;
                layout.addPiece(((IWidgetContainer)IWidgetContainer.class.cast(feature)).getRootWidgetGui(context));
            }
        }
        return layout;
    }

    @Override
    public void receiveGuiUpdateTag(NBTTagCompound compound) {
        for (IFeature feature : this.features.getFeatures()) {
            if (!(feature instanceof IClientFeature) || !compound.func_150297_b(feature.getKey(), 10)) continue;
            IClientFeature clientFeature = (IClientFeature)IClientFeature.class.cast(feature);
            NBTTagCompound update = compound.func_74775_l(feature.getKey());
            clientFeature.handleUpdateTag(update);
        }
    }

    @Override
    @Nullable
    public NBTTagCompound getGuiUpdateTag(boolean resetDirtyFlag) {
        NBTTagCompound compound = new NBTTagCompound();
        for (IFeature feature : this.features.getFeatures()) {
            IServerFeature serverFeature;
            NBTTagCompound update;
            if (!(feature instanceof IServerFeature) || (update = (serverFeature = (IServerFeature)IServerFeature.class.cast(feature)).getGuiUpdateTag(resetDirtyFlag)) == null || update.func_186856_d() <= 0) continue;
            compound.func_74782_a(feature.getKey(), (NBTBase)update);
        }
        return compound.func_186856_d() > 0 ? compound : null;
    }
}

