/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.client.registrations;

import com.mcmoddev.lib.client.renderer.FluidStateMapper;
import com.mcmoddev.lib.init.Blocks;
import com.mcmoddev.lib.init.Fluids;
import com.mcmoddev.lib.init.Items;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockSlab;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RegistrationHelper {
    @SideOnly(value=Side.CLIENT)
    public static void registerItemRender(@Nonnull Item item) {
        RegistrationHelper.registerRender(item);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemRender(@Nonnull String name) {
        Item item = Items.getItemByName(name);
        RegistrationHelper.registerRender(item);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockRender(@Nonnull Block block) {
        if (block instanceof BlockDoor || block instanceof BlockSlab) {
            return;
        }
        RegistrationHelper.registerRender(Item.func_150898_a((Block)block));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockRender(@Nonnull String name) {
        Block block = Blocks.getBlockByName(name);
        if (block instanceof BlockDoor || block instanceof BlockSlab) {
            return;
        }
        RegistrationHelper.registerRender(Item.func_150898_a((Block)block));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerFluidRender(@Nonnull String name) {
        Fluid fluid = FluidRegistry.getFluid((String)name);
        RegistrationHelper.registerFluidRender(fluid);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerFluidRender(@Nonnull Fluid fluid) {
        BlockFluidBase block = Fluids.getFluidBlockByName(fluid.getName());
        Item item = Item.func_150898_a((Block)block);
        ResourceLocation resourceLocation = block.getRegistryName();
        FluidStateMapper mapper = new FluidStateMapper(resourceLocation.func_110624_b() + ":" + fluid.getName());
        if (!resourceLocation.func_110624_b().equals(Loader.instance().activeModContainer().getModId())) {
            return;
        }
        if (item != null) {
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
        }
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRender(@Nonnull Item item) {
        ResourceLocation resourceLocation = item.getRegistryName();
        if (!resourceLocation.func_110624_b().equals(Loader.instance().activeModContainer().getModId())) {
            return;
        }
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(resourceLocation, "inventory"));
    }

    private RegistrationHelper() {
        throw new IllegalAccessError("Not a instantiable class");
    }
}

