/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.block;

import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.material.IMMDObject;
import com.mcmoddev.lib.material.MMDMaterial;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockMMDOre
extends BlockOre
implements IMMDObject {
    private final MMDMaterial mmdMaterial;

    public BlockMMDOre(MMDMaterial material) {
        this(material, false);
    }

    public BlockMMDOre(MMDMaterial material, boolean isSoft) {
        this.mmdMaterial = material;
        float hardnessMax = 5.0f;
        float resistMax = 1.5f;
        String tool = "pickaxe";
        if (isSoft) {
            this.func_149672_a(SoundType.field_185849_b);
            hardnessMax = 2.5f;
            resistMax = 1.5f;
            tool = "shovel";
        } else {
            this.func_149672_a(SoundType.field_185851_d);
        }
        this.field_149782_v = Math.max(hardnessMax, this.mmdMaterial.getOreBlockHardness());
        this.field_149781_w = Math.max(resistMax, this.mmdMaterial.getBlastResistance() * 0.75f);
        this.setHarvestLevel(tool, this.mmdMaterial.getRequiredHarvestLevel());
    }

    public int getExpDrop(IBlockState bs, IBlockAccess w, BlockPos coord, int i) {
        return 0;
    }

    public boolean canEntityDestroy(IBlockState bs, IBlockAccess w, BlockPos coord, Entity entity) {
        return super.canEntityDestroy(bs, w, coord, entity);
    }

    @Override
    public MMDMaterial getMMDMaterial() {
        return this.mmdMaterial;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        int most = 1;
        int least = 1;
        switch (this.mmdMaterial.getType()) {
            case WOOD: 
            case ROCK: 
            case METAL: {
                return 1;
            }
            case MINERAL: {
                most = 4;
                least = 2;
                break;
            }
            case CRYSTAL: {
                most = 4;
                least = 1;
                break;
            }
            case GEM: {
                most = 3;
                least = 2;
                break;
            }
            default: {
                return 1;
            }
        }
        int total = most - least + fortune + 1;
        return least + random.nextInt(total);
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        switch (this.mmdMaterial.getType()) {
            case CRYSTAL: {
                return this.mmdMaterial.getItem(Names.CRYSTAL);
            }
            case GEM: {
                return this.mmdMaterial.getItem(Names.GEM);
            }
            case MINERAL: {
                return this.mmdMaterial.getItem(Names.POWDER);
            }
        }
        return Item.func_150898_a((Block)this);
    }
}

