/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.block;

import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.material.IMMDObject;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.material.MMDMaterialType;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMMDDoor
extends BlockDoor
implements IMMDObject {
    private final MMDMaterial mmdMaterial;

    public BlockMMDDoor(MMDMaterial material) {
        super(material.getToolHarvestLevel() > 0 ? material.getVanillaMaterial() : Material.field_151576_e);
        this.mmdMaterial = material;
        this.func_149672_a(this.mmdMaterial.getSoundType());
        this.field_149782_v = this.mmdMaterial.getBlockHardness();
        this.field_149781_w = this.mmdMaterial.getBlastResistance();
        this.setHarvestLevel(this.mmdMaterial.getHarvestTool(), this.mmdMaterial.getRequiredHarvestLevel());
        this.func_149649_H();
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.mmdMaterial.getItem(Names.DOOR));
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? null : this.mmdMaterial.getItem(Names.DOOR);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate;
        if (this.mmdMaterial.getToolHarvestLevel() > 1 || this.mmdMaterial.getType().equals((Object)MMDMaterialType.MaterialType.METAL)) {
            return false;
        }
        BlockPos blockpos = state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate = pos.equals((Object)blockpos) ? state : worldIn.func_180495_p(blockpos);
        if (iblockstate.func_177230_c() != this) {
            return false;
        }
        IBlockState newState = iblockstate.func_177231_a((IProperty)BlockDoor.field_176519_b);
        worldIn.func_180501_a(blockpos, newState, 10);
        worldIn.func_175704_b(blockpos, pos);
        this.playSound(playerIn, worldIn, blockpos, (Boolean)newState.func_177229_b((IProperty)BlockDoor.field_176519_b));
        return true;
    }

    protected void playSound(@Nullable EntityPlayer player, World worldIn, BlockPos pos, boolean open) {
        boolean isMetal = this.getMMDMaterial().getType().equals((Object)MMDMaterialType.MaterialType.METAL);
        int retVal = open ? (isMetal ? 1005 : 1006) : (isMetal ? 1011 : 1012);
        worldIn.func_180498_a(player, retVal, pos, 0);
    }

    @Override
    public MMDMaterial getMMDMaterial() {
        return this.mmdMaterial;
    }
}

