/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.items;

import blusunrize.immersiveengineering.api.tool.IInternalStorageItem;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import flaxbeard.immersivepetroleum.common.items.ItemIPBase;
import flaxbeard.immersivepetroleum.common.util.IPItemStackHandler;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class ItemIPInternalStorage
extends ItemIPBase
implements IInternalStorageItem {
    public ItemIPInternalStorage(String name, int stackSize, String ... subNames) {
        super(name, stackSize, subNames);
    }

    public abstract int getSlotCount(ItemStack var1);

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return !stack.func_190926_b() ? new IPItemStackHandler(stack) : null;
    }

    public void setContainedItems(ItemStack stack, NonNullList<ItemStack> inventory) {
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (EnumFacing)null);
        if (handler instanceof IItemHandlerModifiable) {
            if (inventory.size() != handler.getSlots()) {
                throw new IllegalArgumentException("Parameter inventory has " + inventory.size() + " slots, capability inventory has " + handler.getSlots());
            }
            for (int i = 0; i < handler.getSlots(); ++i) {
                ((IItemHandlerModifiable)handler).setStackInSlot(i, (ItemStack)inventory.get(i));
            }
        } else {
            IELogger.warn((Object)("No valid inventory handler found for " + stack));
        }
    }

    public NonNullList<ItemStack> getContainedItems(ItemStack stack) {
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (EnumFacing)null);
        if (handler instanceof IPItemStackHandler) {
            return ((IPItemStackHandler)handler).getContainedItems();
        }
        if (handler == null) {
            IELogger.info((Object)("No valid inventory handler found for " + stack));
            return NonNullList.func_191196_a();
        }
        IELogger.warn((Object)("Inefficiently getting contained items. Why does " + stack + " have a non-IE IItemHandler?"));
        NonNullList inv = NonNullList.func_191197_a((int)handler.getSlots(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < handler.getSlots(); ++i) {
            inv.set(i, (Object)handler.getStackInSlot(i));
        }
        return inv;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"Inv")) {
            NBTTagList list = ItemNBTHelper.getTag((ItemStack)stack).func_150295_c("Inv", 10);
            this.setContainedItems(stack, (NonNullList<ItemStack>)Utils.readInventory((NBTTagList)list, (int)this.getSlotCount(stack)));
            ItemNBTHelper.remove((ItemStack)stack, (String)"Inv");
            if (entityIn instanceof EntityPlayerMP && !worldIn.field_72995_K) {
                ((EntityPlayerMP)entityIn).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(-2, itemSlot, stack));
            }
        }
    }
}

